#include <stdio.h>
#include <stdlib.h>

#include "pico/stdlib.h"
#include "hardware/pio.h"
#include "hardware/clocks.h"
#include "ws2812.pio.h"

static const unsigned int neopixel = 28u;

static inline void init() {
    stdio_init_all();
    uint offset = pio_add_program(pio0, &ws2812_program);
    ws2812_program_init(pio0, 0, offset, neopixel, 800000, true);

    sleep_ms(1000);
}

static inline void set_pixel(uint32_t pixel_grb) {
    pio_sm_put_blocking(pio0, 0, pixel_grb * 256);
}

static inline void set_pixel_rgb(uint8_t r, uint8_t g, uint8_t b) {
    set_pixel((32 << 24) + ((uint32_t) r << 16) + ((uint32_t) g << 8) + ((uint32_t) b));
}

int main() {
    init();

    while (true) {
        uint8_t r = 0u;
        do {
            set_pixel_rgb(r, 0u, 255u - r);
            sleep_ms(100);
        } while (++r > 0u);

        uint8_t g = 0u;
        do {
            set_pixel_rgb(255u - g, g, 0u);
            sleep_ms(100);
        } while (++g > 0u);

        uint8_t b = 0u;
        do {
            set_pixel_rgb(0u, 0u, b);
            sleep_ms(100);
        } while (++b > 0u);
    }
}

