import java.net.ServerSocket;
import java.net.Socket;

public class Controller {

    private final int cport;
    static int R;
    private final int timeout;
    private final int rebalance_period;

    public Controller(int cport, int R, int timeout, int rebalance_period) {
        this.cport = cport;
        Controller.R = R;
        this.timeout = timeout;
        this.rebalance_period = rebalance_period;
    }

    public void start() {
        try {
            ServerSocket controller = new ServerSocket(cport);
            FileSystem fileSystem = new FileSystem();
            Server server = new Server(this, fileSystem);
            System.out.println("Start listening for connections");

            for(;;) {
                try {
                    Socket client = controller.accept();

                    new Thread(() -> {
                        try {
                            server.handleClient(client);
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }).start();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

        } catch(Exception e) {
            e.printStackTrace();
        }

    }

    public int getCport() {
        return cport;
    }

    public int getR() {
        return R;
    }

    public int getRebalance_period() {
        return rebalance_period;
    }

    public int getTimeout() {
        return timeout;
    }

    public static void main(String[] args) {
        if(args.length != 4) {
            System.out.println("Incorrect number of arguments for the controller");
            return;
        }

        int cport = Integer.parseInt(args[0]);
        int R = Integer.parseInt(args[1]);
        int timeout = Integer.parseInt(args[2]);
        int rebalance_perios = Integer.parseInt(args[3]);

        new Controller(cport, R, timeout,rebalance_perios).start();
    }
}
