/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.PrintStream;

public abstract class Logger {
    protected static final String ERROR_LOG_MSG_SUFFIX = "ERROR: ";
    protected final LoggingType loggingType;
    protected PrintStream ps;

    /*
     * WARNING - void declaration
     */
    protected Logger(LoggingType loggingType) {
        void var1_1;
        this.loggingType = var1_1;
    }

    protected abstract String getLogFileSuffix();

    protected PrintStream getPrintStream() throws IOException {
        if (this.ps == null) {
            this.ps = new PrintStream(String.valueOf(this.getLogFileSuffix()) + "_" + System.currentTimeMillis() + ".log");
        }
        return this.ps;
    }

    protected boolean logToFile() {
        return this.loggingType == LoggingType.ON_FILE_ONLY || this.loggingType == LoggingType.ON_FILE_AND_TERMINAL;
    }

    protected boolean logToTerminal() {
        return this.loggingType == LoggingType.ON_TERMINAL_ONLY || this.loggingType == LoggingType.ON_FILE_AND_TERMINAL;
    }

    /*
     * WARNING - void declaration
     */
    protected void log(String message) {
        if (this.logToFile()) {
            try {
                this.getPrintStream().println(message);
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
        }
        if (this.logToTerminal()) {
            void var1_1;
            System.out.println((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void connectionAccepted(int remotePort) {
        void var1_1;
        this.log("Connection accepted from port ".concat(String.valueOf((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void connectionEstablished(int remotePort) {
        void var1_1;
        this.log("Connection established to port ".concat(String.valueOf((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void messageSent(int destinationPort, String message) {
        void var2_2;
        void var1_1;
        this.log("Message sent to port " + (int)var1_1 + ": " + (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void messageReceived(int sourcePort, String message) {
        void var2_2;
        void var1_1;
        this.log("Message received from port " + (int)var1_1 + ": " + (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void timeoutExpiredWhileReading(int remotePort) {
        void var1_1;
        this.log("Timeout expired while reading from port ".concat(String.valueOf((int)var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    public void error(String message) {
        void var1_1;
        this.log(ERROR_LOG_MSG_SUFFIX.concat(String.valueOf(var1_1)));
    }

    public static enum LoggingType {
        NO_LOG,
        ON_TERMINAL_ONLY,
        ON_FILE_ONLY,
        ON_FILE_AND_TERMINAL;

    }
}

