
`timescale 1 ns / 1 ps

	module axi_stream_io_v1_0 #
	(
		// Users to add parameters here

		// User parameters ends
		// Do not modify the parameters beyond this line


		// Parameters of Axi Slave Bus Interface axi
		parameter integer C_axi_DATA_WIDTH	= 32,
		parameter integer C_axi_ADDR_WIDTH	= 4,

		// Parameters of Axi Master Bus Interface tx
		parameter integer C_tx_TDATA_WIDTH	= 8,
		parameter integer C_tx_START_COUNT	= 3,

		// Parameters of Axi Slave Bus Interface rx
		parameter integer C_rx_TDATA_WIDTH	= 8
	)
	(
		// Users to add ports here

		// User ports ends
		// Do not modify the ports beyond this line


		// Ports of Axi Slave Bus Interface axi
		input wire  axi_aclk,
		input wire  axi_aresetn,
		input wire [C_axi_ADDR_WIDTH-1 : 0] axi_awaddr,
		input wire [2 : 0] axi_awprot,
		input wire  axi_awvalid,
		output wire  axi_awready,
		input wire [C_axi_DATA_WIDTH-1 : 0] axi_wdata,
		input wire [(C_axi_DATA_WIDTH/8)-1 : 0] axi_wstrb,
		input wire  axi_wvalid,
		output wire  axi_wready,
		output wire [1 : 0] axi_bresp,
		output wire  axi_bvalid,
		input wire  axi_bready,
		input wire [C_axi_ADDR_WIDTH-1 : 0] axi_araddr,
		input wire [2 : 0] axi_arprot,
		input wire  axi_arvalid,
		output wire  axi_arready,
		output wire [C_axi_DATA_WIDTH-1 : 0] axi_rdata,
		output wire [1 : 0] axi_rresp,
		output wire  axi_rvalid,
		input wire  axi_rready,

        output wire interrupt,
		// Ports of Axi Master Bus Interface tx
		output wire  tx_tvalid,
		output wire [C_tx_TDATA_WIDTH-1 : 0] tx_tdata,
		output wire [(C_tx_TDATA_WIDTH/8)-1 : 0] tx_tstrb,
		output wire  tx_tlast,
		input wire  tx_tready,

		// Ports of Axi Slave Bus Interface rx
		output wire  rx_tready,
		input wire [C_rx_TDATA_WIDTH-1 : 0] rx_tdata,
		input wire [(C_rx_TDATA_WIDTH/8)-1 : 0] rx_tstrb,
		input wire  rx_tlast,
		input wire  rx_tvalid
	);
// Instantiation of Axi Bus Interface axi
	iostream_v1_0_axi # ( 
		.C_S_AXI_DATA_WIDTH(C_axi_DATA_WIDTH),
		.C_S_AXI_ADDR_WIDTH(C_axi_ADDR_WIDTH)
	) iostream_v1_0_axi_inst (
		.S_AXI_ACLK(axi_aclk),
		.S_AXI_ARESETN(axi_aresetn),
		.tx_tvalid(tx_tvalid),
		.tx_tdata(tx_tdata),
//		output wire [0 : 0] tx_tstrb,
//		output wire  tx_tlast,
		.tx_tready(tx_tready),
		.rx_tvalid(rx_tvalid),
		.rx_tdata(rx_tdata),
//		input wire [0 : 0] tx_tstrb,
//		input wire  tx_tlast,
		.tx_tready(rx_tready),
		.interrupt(interrupt),
		.S_AXI_AWADDR(axi_awaddr),
		.S_AXI_AWPROT(axi_awprot),
		.S_AXI_AWVALID(axi_awvalid),
		.S_AXI_AWREADY(axi_awready),
		.S_AXI_WDATA(axi_wdata),
		.S_AXI_WSTRB(axi_wstrb),
		.S_AXI_WVALID(axi_wvalid),
		.S_AXI_WREADY(axi_wready),
		.S_AXI_BRESP(axi_bresp),
		.S_AXI_BVALID(axi_bvalid),
		.S_AXI_BREADY(axi_bready),
		.S_AXI_ARADDR(axi_araddr),
		.S_AXI_ARPROT(axi_arprot),
		.S_AXI_ARVALID(axi_arvalid),
		.S_AXI_ARREADY(axi_arready),
		.S_AXI_RDATA(axi_rdata),
		.S_AXI_RRESP(axi_rresp),
		.S_AXI_RVALID(axi_rvalid),
		.S_AXI_RREADY(axi_rready)
	);

assign tx_tstrb[0:0] = tx_tvalid;
assign tx_tlast      = 1'b0;

	// Add user logic here

	// User logic ends

	endmodule
