apk update
apk upgrade

#Setting Java OpenJDK runtime environment variables
export JAVA_HOME="/usr/lib/jvm/java-1.8-openjdk/"
export JAVA_OPTS="-Xmx2G"
export CATALINA_HOME="/var/lib/tomcat"
export CATALINA_BASE="/var/lib/tomcat"

if [ ! -d "/var/lib/tomcat" ]; then
echo "First boot of container: downloading tomcat!"

#Download tomcat 7.0.96
curl -s -o "tomcat7.tar.gz" https://archive.apache.org/dist/tomcat/tomcat-7/v7.0.96/bin/apache-tomcat-7.0.96.tar.gz
echo "Tomcat7 downloaded!"

#probably can be uninstalled to save space 
#apk del curl

#Make tomcat folder and unpack tomcat executable
mv /tomcat7.tar.gz /var/lib/
cd /var/lib/
mkdir tomcat
tar -C tomcat -xzf "tomcat7.tar.gz" --strip-components=1
rm tomcat7.tar.gz
echo "Unpacked Tomcat7!"

#Make JENA folder and unpack .war
cd tomcat
mkdir jena-tdb
cd webapps
mkdir system-modeller
mv /*.war ./system-modeller/
cd system-modeller/
unzip system-modeller-*.war

#Setting MongoDB connection variables
cd WEB-INF/classes/
sed -i 's/spring.data.mongodb.host=localhost/spring.data.mongodb.host='"$MONGO_MONGODB_SERVICE_HOST"'/g' application.properties
sed -i 's/# Mongo/# Mongo\nspring.data.mongodb.username=root\nspring.data.mongodb.password='"$MONGODB_ROOT_PASSWORD"'\nspring.data.mongodb.authentication-database=admin/g' application.properties

cd /var/lib/tomcat/bin
./catalina.sh start

echo "Waiting for tomcat7 to start"
until [ "`curl --silent --show-error --connect-timeout 1 -I http://localhost:8080 | grep 'Coyote'`" != "" ];
do
  echo "Waiting for tomcat7 to start..."
  sleep 5
done

echo "Tomcat7 started!"
echo "Setting reset.on.start to false for subsequent reboots..."

cd /var/lib/tomcat/webapps/system-modeller/WEB-INF/classes/
sed -i 's/reset.on.start=true/reset.on.start=false/g' application.properties
sed -i 's/reset.on.start=true/reset.on.start=false/g' application-production.properties

echo "Restarting tomcat7"

cd /var/lib/tomcat/bin
./catalina.sh stop

sleep 5

else
echo "Tomcat already installed: the container must be restarting?"

fi

if test -n "$(find / -maxdepth 1 -name '*.war' -print -quit)"
then
 echo "This appears to be an upgrade as system-modeller.war is present at root!"
 cd /var/lib/tomcat/webapps
 rm -rf system-modeller
 mkdir system-modeller
 mv /*.war ./system-modeller/
 cd system-modeller/
 unzip system-modeller-*.war
 
 #Setting MongoDB connection variables
 cd WEB-INF/classes/
 sed -i 's/spring.data.mongodb.host=localhost/spring.data.mongodb.host='"$MONGO_MONGODB_SERVICE_HOST"'/g' application.properties
 sed -i 's/# Mongo/# Mongo\nspring.data.mongodb.username=root\nspring.data.mongodb.password='"$MONGODB_ROOT_PASSWORD"'\nspring.data.mongodb.authentication-database=admin/g' application.properties

 cd /var/lib/tomcat/webapps/system-modeller/WEB-INF/classes/
 sed -i 's/reset.on.start=true/reset.on.start=false/g' application.properties
 sed -i 's/reset.on.start=true/reset.on.start=false/g' application-production.properties
 
else
 echo "Restart not due to upgrade: something must have crashed :("
fi

echo "Starting tomcat7"

cd /var/lib/tomcat/bin
./catalina.sh run


#MongoDB GCloud Settings
#spring.data.mongodb.username=root
#spring.data.mongodb.password=0Z5XQR5IEJ
#spring.data.mongodb.authentication-database=admin
#spring.data.mongodb.host=10.3.246.90
#spring.data.mongodb.port=27017
#spring.data.mongodb.database=system-modeller