# Recommending and modelling optimal security practices for smart grid connected IoT devices

IoT devices present many exciting applications for both industrial and consumer use. However, increased dependence on these devices opens up new consequences and attack vectors that an adversary can use to attack a target. This is of particular importance in the case of IoT devices connected to smart grid infrastructure as cyber-attacks could be used to disrupt critical national infrastructure. 

Currently, many IoT devices are very susceptible to cyber-attack due to insufficient or poorly implemented security practices. This project aims to produce and model a collection of policies and protocols that are suitable for mitigating the threats that a smart grid connected IoT device may face. I wish to focus on the following goals within this project: 

- Investigating and conducting a risk assessment on the main vulnerabilities and threats faced by IoT devices within this scenario. 
- Recommend security policies that can mitigate these threats, justifying these policies taking into account secondary factors including the cost to implement and any loss to productivity these policies might incur. 
- Model these policies using Scyther, a formal method based protocol verification tool. 

The scope of this project will be investigating and modelling the best policies and procedures for IoT devices in the smart grid/energy sector.
