import csv

from sklearn import svm, metrics
from sklearn.model_selection import train_test_split

# load training data - array of size (6000, 128) - and labels (1d array of length 6000)
print("Loading training data...")
X = []
y = []
# read the training csv file line by line and parse the data
trainingFile = open("TrainingDataMulti.csv")
reader = csv.reader(trainingFile)
for line in reader:
    # remove the label from the system trace and add it to the training data
    y.append(line.pop()) 
    # add the features of the system trace to the training data
    X.append(line)
print("Finished reading training data - read " + str(len(X)) + " system traces.")

# create a SVM classifier with the linear kernel
classifier = svm.SVC(kernel="linear")
print("Created classifier with linear kernel.")

# test the accuracy of the model
print("Beginning accuracy testing...")
averageAccuracy = 0
for i in range(5):
    print("Testing accuracy - iteration " + str(i) + "/5")
    X_train, X_test, y_train, y_test = train_test_split(X, y, test_size=0.0167)
    classifier.fit(X_train, y_train)
    y_pred = classifier.predict(X_test)
    accuracy = metrics.accuracy_score(y_test, y_pred)
    print("Accuracy: ", accuracy)
    averageAccuracy += accuracy
print("Average accuracy: ", (averageAccuracy/5))
    
# re-train the model with whole data set
classifier.fit(X, y)
print("Trained model.")

# read the test file
testData = []
testFile = open("TestingDataMulti.csv");
reader = csv.reader(testFile)
for line in reader:
    # add the system trace to the list of test data
    testData.append(line)
print("Read test sytem traces.")

# predict the classifications for the test system traces and write them to the results file
print("Writing to results file...")
resultsFile = open("TestingResultsMutli.csv", "w", newline="")
writer = csv.writer(resultsFile)
for trace in testData:
    trace.append(classifier.predict([trace])[0])
    writer.writerow(trace)
resultsFile.close()
print("Finished writing to results file.")
