import React, { useEffect } from 'react';
import { makeStyles } from '@material-ui/core/styles';
import { Container, Button, Paper, TextField, Modal } from '@material-ui/core';
import './TemplateModal.scss';
import CheckCircleOutlineIcon from '@material-ui/icons/CheckCircleOutline';

function getModalStyle() {
  const top = 50;

  return {
    top: 50,
    left: 0,
    right: 0,
    margin: 'auto',
    overflow: 'auto',
    maxHeight: 600
  };
}

const useStyles = makeStyles((theme) => ({
  paper: {
    position: 'absolute',
    width: '60%',
    backgroundColor: theme.palette.background.paper,
    border: '2px solid #000',
    boxShadow: theme.shadows[5],
    padding: theme.spacing(2, 4, 3),
  },
}));

function SubmitFormModal(props) {
  const classes = useStyles();
  // getModalStyle is not a pure function, we roll the style only on the first render
  const [modalStyle] = React.useState(getModalStyle);
  const [qForm, setQForm] = React.useState(false);

  const capitalize = (s) => {
    if (typeof s !== 'string') return ''
    return s.charAt(0).toUpperCase() + s.slice(1)
  }

  useEffect(()=>{
      let useThisObject = {...props.selectedTemplate};
      useThisObject.questions = useThisObject.questions.map((el)=>{
         return el.note = '';
      });
      setQForm(props.selectedTemplate);   
  },[]);


  const onChangeNote = function (value, i) {
    let stateNow = qForm;
    stateNow.questions[i].note = value; 
    setQForm(stateNow);
  }

  const onSelectAnswer = function (event, question, qindex) {

    let value = event.currentTarget.innerText;
    value = capitalize(value.toLowerCase());
    let stateNow = {...qForm};
    stateNow.questions[qindex].selectedanswer = value; 
    setQForm(stateNow);
  }

  let renderedQuestions = 'Loading';

  if(qForm) {
    renderedQuestions = qForm.questions.map((q,qindex)=>{

      let answers = q.answers.map((a, aindex) => {
        let az = a.trim();
        az = capitalize(az);

        return (<Button onClick={(e)=>{onSelectAnswer(e, q , qindex)}} style={{ marginRight: 8 }} 
          variant={q?.selectedanswer !==  az ? "outlined" : "contained"}
         color={q?.selectedanswer == az ? "secondary" : "primary"} key={qindex + aindex + 4324}> {az} 
        </Button>)
      });

      return (<div style={{ width: "60%", margin: 'auto', paddingBottom: 16, borderBottom: '1px solid #999' }} key={qindex}>
      <div style={{ marginTop: 16 }}> <span> Question {`${qindex + 1}`} : </span> {q.question} </div>
      <div style={{ marginTop: 8 }}> <span> Answers: </span> {answers} </div>
        <TextField
            style={{width: '100%'}}
            variant="outlined"
            margin="normal"
            id={"Notes" + qindex}
            helperText={'Please insert a note for your answer'}
            label="Note"
            name="note"
            onChange={(evt) => onChangeNote(evt.target.value, qindex)}
          />
    </div>);
  });
  }

    

  const body = (
    <div style={modalStyle} className={classes.paper}>
      <h2 style={{ textAlign: 'center' }}>Submit form: {qForm.title}</h2>
      <Container component="main" maxWidth="md">
      <h3> Description </h3>
      <p style={{borderBottom: '1px solid #999', padding: '16px 16px 32px 16px'}}> {qForm.description} </p>
        <div className='newformfields'>
          {renderedQuestions}
          </div>
      </Container>

      <div className='newformbuttons'>

        <Button style={{ textAlign: 'center' }} onClick={props.toggleModalState } > Cancel </Button>
        
        <Button
          onClick={() => {  props.submitFS(qForm) }}
          style={{ color: 'green', marginLeft: 50, textAlign: 'center' }} >
          {`Submit`}
        </Button>
      </div>
    </div>
  );

  return (
    <div>
      <Modal
        open={props.open}
        onClose={ props.toggleSubModal }
        aria-labelledby="simple-modal-title"
        aria-describedby="simple-modal-description"
      >
        {body}
      </Modal>
    </div>
  );
}

export default SubmitFormModal;