import React from 'react';
import { connect } from 'react-redux';
import { Link } from 'react-router-dom';
import { makeStyles } from '@material-ui/core/styles';
import AppBar from '@material-ui/core/AppBar';
import Toolbar from '@material-ui/core/Toolbar';
import Typography from '@material-ui/core/Typography';
import Button from '@material-ui/core/Button';
import IconButton from '@material-ui/core/IconButton';
import MenuIcon from '@material-ui/icons/Menu';
import { logoutUser } from '../actions';
import MenuItem from '@material-ui/core/MenuItem';
import './AppMenu.scss';
import {addFormSubsOrTemplate} from '../actions';
//Icons 

import DashboardIcon from '@material-ui/icons/Dashboard';
import AccountCircleIcon from '@material-ui/icons/AccountCircle';
import PowerSettingsNewIcon from '@material-ui/icons/PowerSettingsNew';
import KeyboardArrowUpIcon from '@material-ui/icons/KeyboardArrowUp';
import AssignmentIcon from '@material-ui/icons/Assignment';
import PeopleIcon from '@material-ui/icons/People';

//Modals

import TemplateModal from './TemplateModal.react';

const useStyles = makeStyles((theme) => ({
  root: {
    flexGrow: 1,
  },
  menuButton: {
    marginRight: theme.spacing(2),
    color: '#fff',
    cursor: 'pointer'
  },
  authButton: {
    color: '#fff'
  },
  title: {
    flexGrow: 1,
    margin: 'auto',
    alignSelf: 'center'
  },
}));

const AppMenu = (props) => {
  const iconStyle = {color: 'grey', marginRight: 8};
  return (
    <div className={`appmenu ${props.open ? 'appmenu--open' : ''}` }>
        <div className={'menuitems'}>
          {props.isAuthenticated  && <h3> Admin Menu </h3>}
          {props.isAuthenticated &&  <MenuItem onClick={props.toggleModalState} > <AssignmentIcon style={iconStyle} /> Create New Form Template </MenuItem>}
          {props.isAuthenticated && <Link style={{ textDecoration: 'none', color: '#444' }}  to={'/userhome'}><MenuItem ><DashboardIcon style={iconStyle} /> Form Templates DashBoard</MenuItem></Link>}
          {props.isAuthenticated &&  <Link style={{ textDecoration: 'none', color: '#444' }}  to={'/mysubmissions'}><MenuItem ><AccountCircleIcon style={iconStyle} />My Submissions</MenuItem></Link>}
          {props.isAuthenticated &&  <Link  style={{ textDecoration: 'none', color: '#444' }} to={'/partnerssubmissions'}><MenuItem ><PeopleIcon style={iconStyle} />Submissions from partners</MenuItem></Link>}

          <h3> User Menu </h3>
          {!props.isAuthenticated && <Link style={{ textDecoration: 'none', color: '#444' }} to={'/login'}><MenuItem > <AccountCircleIcon style={{marginRight: 8}} /> Log In</MenuItem></Link>}
          {!props.isAuthenticated && <Link style={{ textDecoration: 'none', color: '#444' }} to={'/signup'}><MenuItem > <PeopleIcon style={{marginRight: 8}} /> Sign Up</MenuItem></Link>}
          
          {props.isAuthenticated && <MenuItem  onClick={props.logout}> <PowerSettingsNewIcon style={iconStyle} /> Logout</MenuItem>}
        </div>
        <div style={{fontSize: 16}} onClick={props.handleClose} className='closemenu'> 
          <KeyboardArrowUpIcon style={{position: 'relative', top: 7}} /> close menu <KeyboardArrowUpIcon style={{position: 'relative', top: 7}} />
        </div>
    </div>
  );
}

const AppHeader = (props) => {
  const classes = useStyles();

  const { dispatch } = props;

  const logout = () => {
    dispatch(logoutUser());
  };

  const addNewForm = (newForm, type)=> {
    newForm.createdby = user.displayName;
    newForm.type = type;
    newForm.createdbyid = user.uid;
    newForm.createdtime =new Date();
    dispatch(addFormSubsOrTemplate(newForm, 'template'));
    toggleModalState();
  };


  let { isAuthenticated } = props;
  let { user } = props;
  let { isAdmin } = props;

  const [open, setOpen] = React.useState(false);
  const [openModal, setOpenModal] = React.useState(false);

  const toggleModalState = () => {
    setOpenModal(!openModal);
  }

  const handleClick = (event) => {
    setOpen(!open);
  };

  const handleClose = () => {
    setOpen(false);
  };

  return (<>
    <div className={classes.root}>
      <AppBar position="static">
        <Toolbar>
          <IconButton edge="start" className={classes.menuButton} onClick={handleClick} color="inherit" aria-label="menu">
            <MenuIcon /> <span style={{marginLeft: 8, fontSize: 16}}> Menu </span>
          </IconButton>
          <div style={{margin: "auto", position: 'relative', left:  isAuthenticated ? 10 : 56  }}>
             <Link to={ isAuthenticated ? '/' : '/'} style={{textDecoration: 'none', color: 'white', cursor: 'pointer'}}>
               <Typography variant="h6" className={classes.title}>
                CompForge
              </Typography>
            </Link>
          </div>
          {isAuthenticated && <div> Welcome {user?.displayName} </div>}
          {!isAuthenticated && <Link style={{ textDecoration: 'none' }} to={'/login'}>
            <Button className={classes.authButton}> <AccountCircleIcon style={{marginRight: 8}} /> Log In</Button>
          </Link>}
          {!isAuthenticated && <Link style={{ textDecoration: 'none', marginLeft: 16 }} to={'/signup'}><Button className={classes.authButton}>
             <PeopleIcon style={{marginRight: 8}} /> Sign up</Button>
          </Link>}
        </Toolbar>
      </AppBar>
      <AppMenu
        toggleModalState={toggleModalState}
        logout={logout}
        isAdmin={isAuthenticated && isAdmin} 
        isAuthenticated={isAuthenticated}
        open={open} handleClose={handleClose}  />
    </div>
    <TemplateModal user={user} addNewForm={addNewForm} open={openModal} toggleModalState={toggleModalState} />
    </>
  );
};

function mapStateToProps(state) {
  return {
    isAuthenticated: state.auth.isAuthenticated,
    user: state.auth.user,
    userId: state.auth.userId,
    isAdmin: state.auth.isAdmin
  }
}

export default connect(mapStateToProps)(AppHeader);