import {
  LOAD__FORMSUB__START,
  LOAD__FORMSUB__SUCCESS,
  LOAD__FORMTEMPLATE__START,
  LOAD__FORMTEMPLATE__SUCCESS,
  ADDTEMPLATE__START,
  LOGOUT_SUCCESS,
  ADDTEMPLATE__DONE,
  FORMS__ERROR
} from '../actions';

export default (state = {
  loading: false,
  formtempate: false,
  formsub: false,
  error: { isError: false, message: "", statusCode: "" },
}, action) => {
  // allow some console logs to be able to see what actions are performed
  console.log('Action Type:', action.type);
  if (action?.error) {
    console.log('Error:', (action?.error));
  }

  switch (action.type) {

    case LOGOUT_SUCCESS:
      return {
        ...state,
        loading: false,
        formtemplate: false,
        formsubs: false
      }

    case LOAD__FORMSUB__START:
    case LOAD__FORMTEMPLATE__START:
      return {
        ...state,
        loading: true
      };

    case LOAD__FORMSUB__SUCCESS:
      return {
        ...state,
        loading: false,
        formsubs: action.payload
      }
    case LOAD__FORMTEMPLATE__SUCCESS:
      return {
        ...state,
        loading: false,
        formtempate: action.payload
      }

    case ADDTEMPLATE__START:
      return {
        ...state,
        loading: true
      };

    case ADDTEMPLATE__DONE:
      return {
        ...state,
        loading: true
      };

    case FORMS__ERROR:
      return {
        ...state,
        loading: false,
        error: { isError: true, message: action.payload.message, statusCode: action.payload.code }
      };

    default:
      return state;
  };
};