import { myFirebase } from "../firebase/firebase";

export const LOAD__FORMSUB__START = 'LOAD__FORMSUB__START';
export const LOAD__FORMSUB__SUCCESS = 'LOAD__FORMSUB__SUCCESS';

export const LOAD__FORMTEMPLATE__START = 'LOAD__FORMTEMPLATE__START';
export const LOAD__FORMTEMPLATE__SUCCESS = 'LOAD__FORMTEMPLATE__SUCCESS';

export const ADDSUB__START = 'ADDSUB__START';
export const ADDSUB__DONE = 'ADDSUB__DONE';


export const ADDTEMPLATE__START = 'ADDTEMPLATE__START';
export const ADDTEMPLATE__DONE = 'DDTEMPLATE__DONE';

export const FORMS__ERROR = 'FORMS__ERROR';

const addTemplateDone = () => {
  return {
    type: ADDTEMPLATE__DONE
  };
};

const addSubDone = () => {
  return {
    type: ADDSUB__DONE
  };
}

const loadSubsStart = () => {
  return {
    type: LOAD__FORMSUB__START
  };
};

const loadTemplatesStart = () => {
  return {
    type: LOAD__FORMTEMPLATE__START
  };
};

const loadSubsDone = (payload) => {
  return {
    type: LOAD__FORMSUB__SUCCESS,
    payload: payload
  };
}

const loadTemplatesDone = (payload) => {
  return {
    type: LOAD__FORMTEMPLATE__SUCCESS,
    payload: payload
  };
}

const formsError = (error) => {
  return {
    type: FORMS__ERROR,
    payload: error
  }
}


//Define Thunks

export const fetchSub = (mysubs = false) => dispatch => {
  let type = 'submission';
  let query = 'sourceowneremail';


  dispatch(loadSubsStart());

  if (mysubs) {
    query = 'submittedbyemail';
  }

  myFirebase.firestore().collection(type)
    .where(query, "==", myFirebase.auth().currentUser.email)
    .orderBy('submittedtime', 'desc')
    .get().then((data) => {
      let dataParsed = [];

      data = data.forEach((el) => {
        let newEl = { ...el.data(), docid: el.id };
        dataParsed.push(newEl);
      });

      if (!mysubs) {
        dataParsed = dataParsed.filter((el) => {
          if (el.submittedbyemail !== myFirebase.auth().currentUser.email) {
            return el;
          }
          return null;
        });
      }

      dispatch(loadSubsDone(dataParsed));
    }).catch((e) => {
      console.log(e);
      dispatch(formsError(e));
    });
}

export const fetchForms = (type, usersall = false) => dispatch => {

  dispatch(loadTemplatesStart());

  if (usersall) {
    myFirebase.firestore().collection(type)
      .orderBy('createdtime', 'desc')
      .get().then((data) => {
        let dataParsed = [];
        data = data.forEach((el) => {
          let newEl = { ...el.data(), docid: el.id };
          dataParsed.push(newEl);
        });

        dispatch(loadTemplatesDone(dataParsed));

      }).catch((e) => {
        dispatch(formsError(e));
      });

  } else {
    myFirebase.firestore().collection(type)
      .where('createdbyid', "==", myFirebase.auth().currentUser.uid)
      .orderBy('createdtime', 'desc')
      .get().then((data) => {
        let dataParsed = [];
        data = data.forEach((el) => {
          let newEl = { ...el.data(), docid: el.id };
          dataParsed.push(newEl);
        });

        //next query
        myFirebase.firestore().collection(type)
          .where('sharewith', 'array-contains', myFirebase.auth().currentUser.email)
          .orderBy('createdtime', 'desc')
          .get().then((data2) => {

            data2 = data2.forEach((el) => {
              let newEl = { ...el.data(), docid: el.id };
              dataParsed.push(newEl);
            });
            dispatch(loadTemplatesDone(dataParsed));

          }).catch((e) => {
            console.log(e);
            dispatch(formsError(e));
          });;

      }).catch((e) => {
        console.log(e);
        dispatch(formsError(e));
      });
  }
};


export const addFormSubsOrTemplate = (fbdoc, type) => dispatch => {
  const email = myFirebase.auth().currentUser.email;


  if (type === 'template' && fbdoc.sharewith && fbdoc.sharewith.length > 0) {
    fbdoc.owner = email;
    fbdoc.sharedby = email;
  } else {
    fbdoc.sharedby = false;
  }

  //based on what is the fbdoc type we know which collection to deal with
  myFirebase.firestore().collection(type).add(fbdoc).then(() => {

    if (type === 'template') {
      dispatch(addTemplateDone());
    } else if (type === 'submission') {
      dispatch(addSubDone());
    }
    dispatch(fetchForms('template'));
  }).catch((err) => {
    dispatch(formsError(err));
  });
};


export const removeSubOrForm = (type, docid, isSub = false) => dispatch => {
  myFirebase.firestore().collection(type).doc(docid).delete().then(() => {
    if (isSub)
    {
      dispatch(fetchSub(true));
    }
    else {
      dispatch(fetchForms(type, false));
    }
  }).catch((err) => {
    dispatch(formsError(err));
  });
};


