import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import { Container, Button, Modal } from '@material-ui/core';
import './TemplateModal.scss';

function getModalStyle() {
  return {
    top: 50,
    left: 0,
    right: 0,
    margin: 'auto',
    overflow: 'auto',
    maxHeight: 600
  };
}

const useStyles = makeStyles((theme) => ({
  paper: {
    position: 'absolute',
    width: '60%',
    backgroundColor: theme.palette.background.paper,
    border: '2px solid #000',
    boxShadow: theme.shadows[5],
    padding: theme.spacing(2, 4, 3),
  },
}));

function ViewTemplateModal(props) {
  const classes = useStyles();
  const [modalStyle] = React.useState(getModalStyle);

  let formData = props.selectedTemplate;
   
  let renderedQuestions = formData.questions.map((el, i) => {
    let answers = el.answers.map((el, i) => {
      return (<Button name="answer" style={{ marginRight: 8 }} variant="outlined" color="primary" key={i + 4324}> {el} </Button>)
    });

    return (<div style={{ width: "60%", margin: 'auto', paddingBottom: 16, borderBottom: '1px solid #999' }} key={i}>
      <div name="viewQuestion" style={{ marginTop: 16 }}> <span> Question: </span> {el.question} </div>
      <div name="viewAnswers" style={{ marginTop: 8 }}> <span> Answers: </span> {answers} </div>
    </div>);
  });


  const body = (
    <div style={modalStyle} className={classes.paper}>
      <h2 name="formTitle" style={{ textAlign: 'center', textDecoration: 'underline' }}>{formData.title}</h2>

      <Container component="main" maxWidth="md">
        <div>
           <h3 name="formDescription">Description</h3>
             <p style={{borderBottom: '1px solid #999', padding: '16px 16px 32px 16px'}}> {formData.description} </p>
           </div>

           <h3>Questions | Responses</h3>
      <div>{renderedQuestions}</div>
      </Container>
      
      <div className='newformbuttons'>
        <Button name="doneButton" style={{ textAlign: 'center' }} onClick={ props.toggleModalState } > Done </Button>
      </div>
    </div>
  );

  return (
    <div>
      <Modal
        open={props.open}
        onClose={ props.toggleModalState}
        aria-labelledby="simple-modal-title"
        aria-describedby="simple-modal-description"
      >
        {body}
      </Modal>
    </div>
  );
}

export default ViewTemplateModal;