import React from 'react';
import { makeStyles } from '@material-ui/core/styles';
import { Container, Button, TextField, Modal } from '@material-ui/core';
import './TemplateModal.scss';

function getModalStyle() {
  return {
    top: 50,
    left: 0,
    right: 0,
    margin: 'auto',
    overflow: 'auto',
    maxHeight: 600
  };
}

const useStyles = makeStyles((theme) => ({
  paper: {
    position: 'absolute',
    width: '60%',
    backgroundColor: theme.palette.background.paper,
    border: '2px solid #000',
    boxShadow: theme.shadows[5],
    padding: theme.spacing(2, 4, 3),
  },
}));

function TemplateModal(props) {
  const classes = useStyles();
  // getModalStyle is not a pure function, we roll the style only on the first render
  const [modalStyle] = React.useState(getModalStyle);

  const [newQuestion, setNewQuestion] = React.useState({
    question: '',
    answers: ""
  });

  const [formState, setFormState] = React.useState({
    createdby: '',
    title: '',
    sharewith: " ",
    createdtime: false,
    description: '',
    questions: [],
  })

  const resetState = function () {
    setFormState({
      createdby: '',
      title: '',
      createdtime: false,
      description: '',
      questions: [],
    });
  }

  const quickValidation = function (value, length) {
    if (value.length > 2 && value.length < length) {
      return true;
    }
    return false;
  }

  const onQuestionChange = function (type, value) {
    let questionStateNew = { ...newQuestion };
    questionStateNew[type] = value;
    setNewQuestion(questionStateNew);
  }

  const addOption = function () {
    // split string of answers to array
    let formStateNew = { ...formState };
    formStateNew.questions.push({ question: newQuestion.question, answers: newQuestion.answers.split(',') });
    setFormState(formStateNew);
    setNewQuestion({ question: "", answers: "" })
  }

  const validateEmail = (emails) => {
 
    if (emails) {
      //sanitize emails
      emails = emails.map((el) => {
        return el.trim();
      });
      if (emails.includes(props.user.email)) {
        emails.splice(emails.indexOf(props.user.email), 1);
      }
    }
    return emails;
  }

  const onChangeState = function (type, value, length) {

    let formStateNew = { ...formState };

    if (type === 'sharewith') {
      formStateNew[type] = validateEmail(value.split(','));
      setFormState(formStateNew);
    } else {
      formStateNew[type] = value;
      if (quickValidation(value, length)) {
        setFormState(formStateNew);
      }

    }

  }

  let renderedQuestions = formState.questions.map((el, i) => {
    let answers = el.answers.map((el, i) => {
      return (<Button style={{ marginRight: 8 }} variant="outlined" color="primary" key={i + 4324}> {el} </Button>)
    });

    return (<div style={{ width: "60%", margin: 'auto', paddingBottom: 16, borderBottom: '1px solid #999' }} key={i}>
      <div style={{ marginTop: 16 }}> <span> Question: </span> {el.question} </div>
      <div style={{ marginTop: 8 }}> <span> Answers: </span> {answers} </div>
    </div>);
  });

  const body = (
    <div style={modalStyle} className={classes.paper}>
      <h2 style={{ textAlign: 'center' }}>Create Form Template</h2>

      <Container component="main" maxWidth="md">
        <div className='newformfields'>
          <TextField
            variant="outlined"
            margin="normal"
            id="Formtitle"
            error={!quickValidation(formState.title, 60)}
            helperText={'Please insert a short description about this form. Max 60 characters'}
            label="Form title"
            name="title"
            onChange={(evt) => onChangeState('title', evt.target.value, 60)}
          />

          <TextField
            variant="outlined"
            margin="normal"
            id="Formdescription"
            error={!quickValidation(formState.description, 300)}
            helperText={'Please insert a title for this form. Max 300 characters'}
            label="Form description"
            name="description"
            onChange={(evt) => onChangeState('description', evt.target.value, 300)}
          />

          <TextField
            variant="outlined"
            margin="normal"
            id="Sharewith"
            value={formState.sharewith && typeof formState.sharewith !== 'string' && formState.sharewith.length > 0 ?
              formState.sharewith.join(', ') : formState.sharewith}
            //error={validateEmail(formState.sharewith)}
            helperText={'Add email address for the partners you want to share with comma seprated (your email not accepted as a value)'}
            label=" (optional) Share with"
            name="sharewith"
            onChange={(evt) => onChangeState('sharewith', evt.target.value, 100)}
          />

        </div>
        <div className='newformquestions'>

          <TextField
            variant="outlined"
            margin="normal"
            id="Question"
            helperText={'Insert the question text here.'}
            label="Question"
            name="question"
            value={newQuestion.question}
            onChange={(evt) => onQuestionChange('question', evt.target.value)}
          />
          <TextField
            variant="outlined"
            margin="normal"
            id="Answers"
            value={newQuestion.answers}
            helperText={'Please insert answers comma separated ex: (Yes, No, Maybe)'}
            label="List Answers"
            name="answers"
            onChange={(evt) => onQuestionChange('answers', evt.target.value)}
          />

          <Button name="addEntry" style={{ width: 100, color: 'green', display: 'block' }} onClick={addOption}> Add an entry </Button>
        </div>
      </Container>
      <div>{renderedQuestions}</div>
      <div className='newformbuttons'>
        <Button style={{ textAlign: 'center' }} onClick={() => { setNewQuestion({ question: '', answers: '' }); resetState(); props.toggleModalState() }} > Cancel </Button>
        <Button
          name="submit"
          onClick={() => { setNewQuestion({ question: '', answers: '' }); props.addNewForm(formState, 'template') }}
          disabled={formState.title.length < 2 && formState.questions.length < 1}
          style={{ color: 'green', marginLeft: 50, textAlign: 'center' }} >
          {formState.title.length < 2 && formState.questions.length < 1 ? `Disabled` : `Submit`}
        </Button>
      </div>
    </div>
  );

  return (
    <div>
      <Modal
        open={props.open}
        onClose={() => { resetState(); props.toggleModalState() }}
        aria-labelledby="simple-modal-title"
        aria-describedby="simple-modal-description"
      >
        {body}
      </Modal>
    </div>
  );
}

export default TemplateModal;