import React, { useEffect } from 'react';
import { connect } from 'react-redux';
import { fetchSub, removeSubOrForm} from '../actions';

import './UserDashboard.scss';
import { makeStyles } from '@material-ui/core/styles';
import Table from '@material-ui/core/Table';
import TableBody from '@material-ui/core/TableBody';
import TableCell from '@material-ui/core/TableCell';
import TableContainer from '@material-ui/core/TableContainer';
import TableHead from '@material-ui/core/TableHead';
import TableRow from '@material-ui/core/TableRow';
import Paper from '@material-ui/core/Paper';
import moment from 'moment';
import ViewSubModal from './ViewSubModal.react';
import ConfirmDeletion from './ConfirmDeletion.react';
import Loader from './Loader.react';
//Icons

import DeleteIcon from '@material-ui/icons/Delete';
import VisibilityIcon from '@material-ui/icons/Visibility';


const useStyles = makeStyles({
  table: {
    minWidth: 650,
  },
});

const SubsScreen = (props) => {
  let { loading } = props;
  let { formsubs } = props;
  let { userId } = props;
  const { dispatch } = props;
  const classes = useStyles();

  const [openModal, setOpenModal] = React.useState(false);
  const [openConfirmModal, setOpenConfirmModal] = React.useState(false);
  const [selectedEl, setSelectedEl] = React.useState(false);

  const confirmDelete = (type, doc) => {
    dispatch(removeSubOrForm(type, doc.docid, true));
    setOpenConfirmModal(!openConfirmModal)
  }

  const toggleConfirmModal = (doc) => {
    if(doc) {
      setSelectedEl(doc);
    }
    setOpenConfirmModal(!openConfirmModal);
  }

  const toggleModalState = (el) => {
    if (el && openModal === false) {
      setSelectedEl(el);
    }
    setOpenModal(!openModal);
  }

  useEffect(() => {
    //Load the template forms here then render them
    dispatch(fetchSub(props.mySubs));
  }, []);

  if (loading) {
    return <div className='dashboard dashboard--loader'>
      <div><Loader /></div>
    </div>;
  }
  

  if(formsubs && formsubs.length > 0 ){

    let subRows = formsubs.map((el, i) => {

      return (<TableRow key={i}>
        <TableCell component="th" scope="row">{el.formdata.title}</TableCell>
        <TableCell align="left">{el.formdata.questions.length}</TableCell>
        <TableCell style={{ minWidth: 100 }} align="left">{moment.unix(el.submittedtime?.seconds).format("DD/MM/YYYY")} </TableCell>
        <TableCell align="left">{el.submittedbyname}</TableCell>
        <TableCell align="left">{el.submittedbyemail}</TableCell>
        <TableCell align="right"><div style={{padding: 16, paddingRight: 0}}>
          <VisibilityIcon name="viewSubmissionButton" onClick={() => {toggleModalState(el)}} 
          style={{ cursor: 'pointer', color: '#3498DB', fontSize: 16}} />

          {userId === el.submittedbyid &&
            <DeleteIcon name="deleteSubmissionButton" onClick={() => { toggleConfirmModal(el) }}
             style={{ fontSize: 16, marginLeft: 8, cursor: 'pointer', color: '#E74C3C' }} />}
          </div>
        </TableCell>
      </TableRow>);
    });;

    return (<>
      <div className='dashboard dashboard--table' > {`${props.mySubs ? 'My' : 'Partners'}`} Form Submissions </div>
      <TableContainer className={'udbpaper-mui'} component={Paper}>
        <Table name="formSubmissionsTable" className={classes.table} size="small" aria-label="a dense table">
          <TableHead>
            <TableRow>
              <TableCell>Title</TableCell>
              <TableCell align="left">Questions</TableCell>
              <TableCell align="left">Date Submitted</TableCell>
              <TableCell align="left">Partner</TableCell>
              <TableCell align="left">Email</TableCell>
              <TableCell align="right">Actions</TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            {subRows}
          </TableBody>
        </Table>
      </TableContainer>

      {openModal && <ViewSubModal
        open={openModal}
        selectedTemplate={selectedEl}
        toggleModalState={toggleModalState}
      />}

      {openConfirmModal && <ConfirmDeletion
        open={openConfirmModal}
        doc={selectedEl}
        type={'submission'}
        toggleConfirmModal={toggleConfirmModal}
        confirmDelete={confirmDelete}
      />}
    </>);
  }

  if (!formsubs || formsubs.length === 0) {
    return (<div className='dashboard dashboard--table' > You have not {props.mySubs ? "made" : "received"} any submissions yet. </div>);
  }
};

function mapStateToProps(state) {
  return {
    formsubs: state.form.formsubs,
    loading: state.form.loading,
    isAdmin: state.auth.isAdmin,
    userId: state.auth.userId,
    user: state.auth.user
  }
}

export default connect(mapStateToProps)(SubsScreen); 