import React from 'react';
import { Route, Switch } from "react-router-dom";
import { connect } from "react-redux";

//Higher order component protected route
import ProtectedRoute from "./Components/ProtectedRoute.react";

// Presentational Components
import AppHeader from "./Components/AppHeader.react";
// import HomePage from "./Components/HomePage.react";
import Login from "./Components/Login.react";
import UserDashboard from "./Components/UserDashboard.react";
import Signup from "./Components/Signup.react";
import SubsScreen from "./Components/SubsScreen.react";
import './App.scss';

function App(props) {
  const { isAuthenticated, isVerifying  , user } = props;

  return (
    <div className="rootApp" style={{ maxWidth: 1200, margin: '16px auto auto' }}>
      <AppHeader isAuthenticated={isAuthenticated} isVerifying={isVerifying} />
      <Switch>
        <ProtectedRoute
          exact path='/'
          component={()=>{return (<UserDashboard user={user ? user : false} />)}}
          isAuthenticated={isAuthenticated}
          isVerifying={isVerifying} >
        </ProtectedRoute>

        <ProtectedRoute
          exact path='/mysubmissions'
          component={()=>{return (<SubsScreen mySubs={true} user={user ? user : false} />)}}
          isAuthenticated={isAuthenticated}
          isVerifying={isVerifying} >
        </ProtectedRoute>

        <ProtectedRoute
          exact path='/partnerssubmissions'
          component={()=>{return (<SubsScreen mySubs={false} user={user ? user : false} />)}}
          isAuthenticated={isAuthenticated}
          isVerifying={isVerifying} >
        </ProtectedRoute>

        <Route path="/login" component={Login} />

        <Route path="/signup" component={Signup} />
      </Switch>
    </div>
  );
}

function mapStateToProps(state) {
  return {
    isAuthenticated: state.auth.isAuthenticated,
    isVerifying: state.auth.isVerifying,
    user: state.auth.user
  };
}

export default connect(mapStateToProps)(App);
