import React, { useEffect } from 'react';
import { connect } from 'react-redux';
import { fetchForms, removeSubOrForm , addFormSubsOrTemplate} from '../actions';
import { Link } from 'react-router-dom';
import Loader from './Loader.react';
import { Typography } from "@material-ui/core";
import './UserDashboard.scss';
import { makeStyles } from '@material-ui/core/styles';
import Table from '@material-ui/core/Table';
import Button from '@material-ui/core/Button';
import TableBody from '@material-ui/core/TableBody';
import TableCell from '@material-ui/core/TableCell';
import TableContainer from '@material-ui/core/TableContainer';
import TableHead from '@material-ui/core/TableHead';
import TableRow from '@material-ui/core/TableRow';
import Paper from '@material-ui/core/Paper';
import moment from 'moment';
import ViewTemplateModal from './ViewTemplateModal.react';
import SubmitFormModal from './SubmitFormModal.react';
import ConfirmDeletion from './ConfirmDeletion.react';
//Icons

import DeleteIcon from '@material-ui/icons/Delete';
import VisibilityIcon from '@material-ui/icons/Visibility';
import ContactMailIcon from '@material-ui/icons/ContactMail';

const useStyles = makeStyles({
  table: {
    minWidth: 650,
  },
});

const UserDashboard = (props) => {
  let { loading } = props;
  let { formtempate } = props;
  let { user } = props;
  //let { isAdmin } = props;
  let { userId } = props;
  const { dispatch } = props;
  const classes = useStyles();

  const [openModal, setOpenModal] = React.useState(false);
  const [openSubModal, setOpenSubModal] = React.useState(false);
  const [openConfirmModal, setOpenConfirmModal] = React.useState(false);

  const [selectedEl, setSelectedEl] = React.useState(false);

  const submitFS = (sfObj, formDoc) => {
      let newSub = {};
      newSub.type = 'submission';
      newSub.formdata = {
        description: sfObj.description,
        title: sfObj.title,
        questions: sfObj.questions
      };

      newSub.sourceowneremail = sfObj.owner;
      newSub.sourceformid = sfObj.docid;
      newSub.submittedbyid = userId;
      newSub.submittedbyemail = user.email;
      newSub.submittedbyname = user.displayName;
      newSub.submittedtime = new Date();

      dispatch(addFormSubsOrTemplate(newSub, 'submission'));
      setOpenSubModal(false);
  }

  const confirmDelete = (type, doc) => {
    dispatch(removeSubOrForm(type, doc.docid));
    setOpenConfirmModal(!openConfirmModal)
  }

  const toggleConfirmModal = (doc) => {
    if(doc) {
      setSelectedEl(doc);
    }
    setOpenConfirmModal(!openConfirmModal);
  } 

  const toggleSubModal = (el) => {
    if (el && openSubModal === false) {
      setSelectedEl(el);
    }
    setOpenSubModal(!openSubModal);
  }

  const toggleModalState = (el) => {
    if (el && openModal === false) {
      setSelectedEl(el);
    }
    setOpenModal(!openModal);
  }

  useEffect(() => {
    //Load the template forms here then render them
    dispatch(fetchForms('template', false));
  }, []);

  if (loading) {
    return <div className='dashboard dashboard--loader'>
      <div><Loader /></div>
    </div>;
  }

  if (formtempate) {

    let formRows = formtempate.map((el, i) => {

      return (<TableRow key={i}>
        <TableCell component="th" scope="row">
          {el.title}
        </TableCell>
        <TableCell style={{ maxWidth: 360 }} size='small' align="left">{el.description}</TableCell>
        <TableCell align="left">{el.questions.length}</TableCell>
        <TableCell style={{ minWidth: 100 }} align="left">{moment.unix(el.createdtime?.seconds).format("DD MMM YY")} </TableCell>
        <TableCell align="left">{el.createdby}</TableCell>
        {<TableCell align="left">{el.sharedby && user.email !== el.sharedby ? el.sharedby : '-'}</TableCell>}
        <TableCell style={{ minWidth: 90 }} align="right">
          <div style={{padding: 16, paddingRight: 0}}>
          <VisibilityIcon onClick={() => toggleModalState(el)} 
          style={{ cursor: 'pointer', color: '#3498DB', fontSize: 16}} />

          <ContactMailIcon onClick={() => toggleSubModal(el)} 
          style={{ fontSize: 16, cursor: 'pointer', color: '#138D75', marginLeft: 8 }} />

          {userId === el.createdbyid &&
            <DeleteIcon onClick={() => { toggleConfirmModal(el) }}
             style={{ fontSize: 16, marginLeft: 8, cursor: 'pointer', color: '#E74C3C' }} />}
          </div>   
        </TableCell>
      </TableRow>);
    });

    return (<>
      <div className='dashboard dashboard--table' >Form Templates DashBoard </div>
      <TableContainer className={'udbpaper-mui'} component={Paper}>
        <Table className={classes.table} size="small" aria-label="a dense table">
          <TableHead>
            <TableRow>
              <TableCell>Title</TableCell>
              <TableCell size='small' align="left">Description</TableCell>
              <TableCell align="left">Number of Questions</TableCell>
              <TableCell align="left">Created</TableCell>
              <TableCell align="left">Created by</TableCell>
              <TableCell align="left">Shared by</TableCell>
              <TableCell align="right">Actions</TableCell>
            </TableRow>
          </TableHead>
          <TableBody>
            {formRows}
          </TableBody>
        </Table>
      </TableContainer>

      {openModal && <ViewTemplateModal
        open={openModal}
        selectedTemplate={selectedEl}
        toggleModalState={toggleModalState}
      />}
      {openConfirmModal && <ConfirmDeletion
        open={openConfirmModal}
        doc={selectedEl}
        type={'template'}
        toggleConfirmModal={toggleConfirmModal}
        confirmDelete={confirmDelete}
      />}

      {openSubModal && <SubmitFormModal
        open={openSubModal}
        submitFS={submitFS}
        selectedTemplate={selectedEl}
        toggleModalState={toggleSubModal}
      />}
    </>);
  }

  if (!formtempate) {
    return (<div className='dashboard dashboard--table' > No template forms create. Please create a new form </div>);
  }

};


function mapStateToProps(state) {
  return {
    loading: state.form.loading,
    formtempate: state.form.formtempate,
    isAdmin: state.auth.isAdmin,
    userId: state.auth.userId,
    user: state.auth.user
  }
}



export default connect(mapStateToProps)(UserDashboard); 