import React from 'react';
import Button from '@material-ui/core/Button';
import Dialog from '@material-ui/core/Dialog';
import DialogActions from '@material-ui/core/DialogActions';
import DialogContent from '@material-ui/core/DialogContent';
import DialogContentText from '@material-ui/core/DialogContentText';
import DialogTitle from '@material-ui/core/DialogTitle';

function ConfirmDelete(props) {

  return (
    <div>
      <Dialog
        open={props.open}
        onClose={props.toggleConfirmModal}
        aria-labelledby="alert-dialog-title"
        aria-describedby="alert-dialog-description"
      >
        <DialogTitle id="alert-dialog-title">{"Confirm deletion"}</DialogTitle>
        <DialogContent>
          <DialogContentText id="alert-dialog-description">
            Are you sure you want to delete this template? - {props.doc.title}
          </DialogContentText>
        </DialogContent>
        <DialogActions>
          <Button onClick={props.toggleConfirmModal} color="primary">
            Disagree
          </Button>
          <Button onClick={()=>{ props.confirmDelete(props.type, props.doc) }} color="primary" autoFocus>
            Agree
          </Button>
        </DialogActions>
      </Dialog>
    </div>
  );
}

export default ConfirmDelete;