#include <Arduino.h>
#include "HR_TimerInterrupt.hpp"
#include "HR_Threads.hpp"

void setup() {

  HR_setup();

  TaskHandle_t bpmProcessingThreadHandle;
  TaskHandle_t bpmReadingThreadHandle;

  xTaskCreatePinnedToCore(
      HR_bpm_processing, /* Function to implement the task */
      "bpm-processing-thread", /* Name of the task */
      10000,  /* Stack size in words */
      &bpmData,  /* Task input parameter */
      0,  /* Priority of the task */
      &bpmProcessingThreadHandle,  /* Task handle. */
      0); /* Core where the task should run */

  xTaskCreatePinnedToCore(
      HR_bpm_reading, /* Function to implement the task */
      "bpm-reading-thread", /* Name of the task */
      10000,  /* Stack size in words */
      &bpmData,  /* Task input parameter */
      0,  /* Priority of the task */
      &bpmReadingThreadHandle,  /* Task handle. */
      0); /* Core where the task should run */

}

void loop() {

  delay(100);

}
