#include "HR_TimerInterrupt.hpp"

volatile int interruptCounter;

static hw_timer_t *timer = NULL;
static portMUX_TYPE timerMux = portMUX_INITIALIZER_UNLOCKED;

void IRAM_ATTR onTimer(){
  portENTER_CRITICAL_ISR(&timerMux);
  interruptCounter++;
  portEXIT_CRITICAL_ISR(&timerMux);
}

void timer_setup() {

  timer = timerBegin(0, 80, true);
  timerAttachInterrupt(timer, &onTimer, true);
  timerAlarmWrite(timer, 10, true);
  timerAlarmEnable(timer);

}


/*
void timer_loop(void *parameter) {
  
  //Serial.println("Timer loop thread started");
  
  for(;;) {

    if (interruptCounter > 0){

    portENTER_CRITICAL(&timerMux);
    interruptCounter--;
    portEXIT_CRITICAL(&timerMux);

    xSemaphoreTake(counterMux,50);
    totalInterruptCounter++;
    xSemaphoreGive(counterMux);

    //Serial.print("An interrupt has occured. Total number: ");
    //Serial.println(totalInterruptCounter);
    
    delay(10);

    }

  }

}
*/