#include "HR_Threads.hpp"

bpmDataArray_data bpmData;

void HR_setup()
{
  analogReadResolution(10);
  timer_setup();

  bpmData.bpmDataArray = new uint32_t[10000];
  
  #ifdef HR_DEBUG_PRINT
  Serial.println("Execute Heart Rate Sensor...");
  #endif
}

void HR_bpm_processing(void *parameter)
{
    static int totalNumber;
    static int averageHeartBeat;

    bpmDataArray_data* shared_bpmData = (bpmDataArray_data*)parameter;

    for(;;){

        for(int i = 0; i < shared_bpmData->bpmDataArrayCurrentLength; i++){
            totalNumber += shared_bpmData->bpmDataArray[i];
        }

        if(shared_bpmData->bpmDataArrayCurrentLength != 0){
            averageHeartBeat = totalNumber / shared_bpmData->bpmDataArrayCurrentLength;
            #ifdef HR_DEBUG_PRINT
            Serial.println(averageHeartBeat);
            #endif
        }

        shared_bpmData->bpmDataArrayCurrentLength = 0;
        totalNumber = 0;
        delay(10000);
        
    }
}

void HR_bpm_reading(void* parameter)
{
  static const int proxPin = 36; // Proximity Detecting circuit output connected to GPIO 36 (ADC1 CH0)
  static const int bpfPin = 39; // Band Pass Filter output connected to GPIO 39 (ADC1 CH3)

  static int pinSelect = bpfPin;
  static int threshold = 100;
  static double seconds = 0;
  static uint32_t frequency = 0;

  static SemaphoreHandle_t bpmDataArrayMux;
  static SemaphoreHandle_t counterMux;
  bpmDataArrayMux = xSemaphoreCreateMutex();
  counterMux = xSemaphoreCreateMutex();

  bpmDataArray_data* shared_bpmData = (bpmDataArray_data*)parameter;

  for(;;)
  {
    while(analogRead(pinSelect) <= threshold);

    xSemaphoreTake(counterMux,50);
    interruptCounter = 0;
    xSemaphoreGive(counterMux);

    while(analogRead(pinSelect) > threshold);
    while(analogRead(pinSelect) <= threshold);

    seconds = ((double) interruptCounter / (double) 100000);
    frequency = (1/seconds) * 60;

    if(60 <= frequency && frequency <= 170)
    {
      #ifdef HR_DEBUG_PRINT
      Serial.print(analogRead(proxPin));
      Serial.print(" / ");
      Serial.print(analogRead(bpfPin));
      Serial.print(" : ");
      Serial.print(interruptCounter);
      Serial.print(" -> ");
      Serial.println(frequency);
      #endif

      xSemaphoreTake(bpmDataArrayMux, 200);
      shared_bpmData->bpmDataArray[shared_bpmData->bpmDataArrayCurrentLength] = frequency;
      shared_bpmData->bpmDataArrayCurrentLength++;
      xSemaphoreGive(bpmDataArrayMux);
    }

    while(analogRead(pinSelect) > threshold);

    delay(5);
  }
}