#include "DenisBluetooth.hpp"

BLECharacteristic *jumpCounterChar;

void _denisBluetooth_setup()
{
  BLEDevice::init("Dancing croc Right");
  BLEServer *server = BLEDevice::createServer();
  BLEService *mainService = server->createService(CROC_SERVICE_UUID);

  //Initialize characteristics (with read/write access and notification permissions)
  jumpCounterChar = mainService->createCharacteristic(
                                            CROCE_MOVE_DETECTOR_UUID,
                                            BLECharacteristic::PROPERTY_READ |
                                            BLECharacteristic::PROPERTY_WRITE |
                                            BLECharacteristic::PROPERTY_NOTIFY |
                                            BLECharacteristic::PROPERTY_INDICATE
                                            );

 

  jumpCounterChar->addDescriptor(new BLE2902());

  mainService->start();
 

  //Set up broadcasting
  BLEAdvertising *pAdvertising = BLEDevice::getAdvertising();
  pAdvertising->addServiceUUID(CROC_SERVICE_UUID);
  pAdvertising->setScanResponse(true);
  pAdvertising->setMinPreferred(0x08); 
  pAdvertising->setMinPreferred(0x16);
  BLEDevice::startAdvertising();

  #ifdef BLUETOOTH_DEBUG_PRINT
  Serial.println("GATT server set up");
  #endif
}
