#ifndef DANCINGCROCS_HPP
#define DANCINGCROCS_HPP

#include <Wire.h>  // Wire library - used for I2C communication
#include <Arduino.h>

//#define ADXL375_DEBUG_PRINT /* If defined it will send ADXL375 x, y, z data trough UART */
//#define ADXL375_DANCING_SERIAL_PRINT // If defined will print out current foot move
//#define ADXL375_JUMPING_SERIAL_PRINT
//#define ADXL375_CALIBRATE // If defined will just print raw x,y,z


//#define _robADXL375_setup setup             //  Comment out when running whole program.
//#define _robADXL375_reading loop               //  


#define Left 192                                        //  Defines the values for each direction .
#define Right 48
#define Backward 12
#define Forward 3

#define Flat 1                                          //  Defines the names for the state machine
#define Above 3

#define Jump 240                                       //  Defines the value for if a jump has occurred.
#define InAir 15
#define Landed 0

#define xCalibrated 1.2                                 //
#define yCalibrated -6.7                                //  Must run a simple run first time to get the average values of croc still.
#define zCalibrated 14.9
#define  ADXL375  0x53  // I2C address of the ADXL375

#define potPin 25                                       //  Used if rubber is wanted.

void _robADXL375_dancing();
void _robADXL375_setup();
void _robADXL375_reading();
void _robADXL375_dancingDecode();
void _robADXL375_jump();
#endif