//
//        Base I2C code for interaction taken from 
//        https://howtomechatronics.com/tutorials/arduino/how-to-track-orientation-with-arduino-and-adxl345-accelerometer/
//        
//        And then adapted to work with ADXL375
//   
//        Remember to change calibration values!!!
//    
// 
//        Sending unit8 00000011  Forwards
//                      00001100  Backwards 
//                      00110000  Right
//                      11000000  Left
//              
//                      11110000  Jump
//                      00001111  In Air
//                      00000000  Landed
//   
//        Once there is a resultant accelration, the code checks for both sideways and front ways, which is the leading "Velocity" (sum).
//        Once the movement stops, it calculates which direction had the "most speed" (sum of absolute of acceleration). It then picks
//        which movement to send.
//
//        The sendDirection is NOT reset and may need to be for bluetooth.
//
//        
//        
//        Uses resultant to make sure a false flat line is not prodcued. In air if resultant is above a certain value.
//        
//        Sets a jump has occurred if the "velocity"is above 100. Will need to be tuned to how high grace jumps.      
//
//                  █████████▀██████████████████████████████
//                  █████████▀██████████████████████████████
//                  █████████▀██████████████████████████████
//                  ████████▀▀██████████████████████████████
//                  ███████▀▀▀██████████████████████████████
//                  ███████▀▀▀▀█████████████████████████████
//                  ███████▀▀▀▀█████████████████████████████
//                  ███████▀▀▀▀█████████████████████████████
//                  ███████▀▀▀▀██████████████████▀▀▀████████
//                  ████████▀▀▀█████████████████▀▀▀▀▀███████
//                  ████████▀▀▀▀███████████████▀▀▀▀▀▀▀██████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀█████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀▀███████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀█████▀▀▀▀▀▀▀▀████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀██▀▀▀▀▀▀▀█████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀██████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀███████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀████████
//                  █████████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀███████
//                  █████████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀█████
//                  ████████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀████
//                  ███████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀███
//                  ██████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀███▀▀▀▀▀▀▀██
//                  █████████████▀▀▀▀▀▀▀▀▀▀▀▀███████▀▀▀▀▀▀▀█
//                  █████████████▀▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀
//                  █████████████▀▀▀▀▀▀▀▀██████████████▀▀▀▀▀
//                  ████████████▀▀▀▀▀▀▀███████████████▀▀▀▀▀▀
//                  ████████████▀▀▀▀▀▀▀█████████████▀▀▀▀▀▀▀▀
//                  ████████████▀▀▀▀▀▀▀████████████▀▀▀▀▀▀▀▀█
//                  ████████████▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀▀▀█
//                  ████████████▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀▀███
//                  ███████████▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀▀████
//                  ██████████▀▀▀▀▀▀▀▀███████▀▀▀▀▀▀▀█▀▀█████
//                  █████████▀▀▀▀▀▀▀▀▀██████▀▀▀▀▀▀▀▀████████
//                  ███████▀▀▀▀▀▀▀▀▀▀▀▀█████████████████████
//                  ██████▀▀▀▀▀▀▀▀▀▀▀▀▀█████████████████████
//                  █████▀▀▀▀▀▀▀▀█▀▀▀▀▀▀████████████████████
//                  ████▀▀▀▀▀▀▀▀███▀▀▀▀▀▀███████████████████
//                  ███▀▀▀▀▀▀▀▀████▀▀▀▀▀▀▀██████████████████
//                  ██▀▀▀▀▀▀▀▀██████▀▀▀▀▀▀▀█████████████████
//                  █▀▀▀▀▀▀▀█████████▀▀▀▀▀▀█████████████████
//                  ▀▀▀▀▀▀▀███████████▀▀▀▀▀▀████████████████
//                  ▀▀▀▀▀▀████████████▀▀▀▀▀▀▀███████████████
//                  ▀▀▀▀▀▀▀████████████▀▀▀▀▀▀▀██████████████
//                  ▀▀▀▀▀▀▀▀████████████▀▀▀▀▀▀▀█████████████
//                  █▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀█████████████
//                  █▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀████████████
//                  ██▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀▀███████████
//                  ██▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀███████████
//                  ██▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀▀██████████
//                  ███▀▀▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀██████████
//                  ███▀▀▀▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀█████████
//                  ███▀▀▀▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀█████████
//                  ████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀█████████
//                  ████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀▀████████
//                  █████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀████████
//                  █████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀████████
//                  ██████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀███████
//                  ██████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀███████
//                  ██████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀███████
//                  ███████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀███████
//                  ███████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀███████
//                      .-._   _ _ _ _ _ _ _ _
//           .-''-.__.-'00  '-' ' ' ' ' ' ' ' '-.
//          '.___ '    .   .--_'-' '-' '-' _'-' '._
//           V: V 'vv-'   '_   '.       .'  _..' '.'.
//             '=.____.=_.--'   :_.__.__:_   '.   : :
//                     (((____.-'        '-.  /   : :
//                                      (((-'\ .' /
//                                     _____..'  .'
//                                    '-._____.-'


#include "DancingCrocs.hpp"

#include "DenisBluetooth.hpp"

static uint8_t sendDirection;         //  Left 192 Right 48 Backward 12 Forward 3         current line 144 163

extern BLECharacteristic *jumpCounterChar;    


static uint8_t  sendJumping;          // Jump 240 InAir 15 Landed 0     (current line 248 235 241)


int16_t xRaw, yRaw, zRaw;  // Outputs
static unsigned int state; 
float xCal,yCal,zCal,rCal;

float ySum,zSum,xSum;

float yAbsSum,zAbsSum;


uint8_t frontDirection = 0;
uint8_t sideDirection=0;

bool zPicked=false;
bool yPicked=false;

bool first=true;


unsigned long lastTimeJump;
unsigned long lastTimeDance;

void _robADXL375_dancingDecode()                   //    Decodes and sends the direction
{
  if (yAbsSum>zAbsSum)
  {
    sendDirection=sideDirection;
    #ifdef ADXL375_DANCING_SERIAL_PRINT
    if (sideDirection==Left)
    {
    Serial.println("Left");
    }
    else if (sideDirection==Right)
    {
      Serial.println("Right");
    }
    else
    {
      Serial.print("ERROR!! side is ");
      Serial.println(sideDirection);
    }
    #endif
  }
  else
  {  
    sendDirection=sideDirection;                 
    #ifdef ADXL375_DANCING_SERIAL_PRINT                  
    if (frontDirection==Forward)
    {
    Serial.println("Forward");
    }
    else if (frontDirection==Backward)
    {
      Serial.println("Backward");
    }
    else
    {
      Serial.print("ERROR!! front is ");
      Serial.println(frontDirection);
    }
    
    #endif
  }

}

void _robADXL375_dancing()
{
  if ((rCal>3) || ((yAbsSum>100)&&(rCal>1.5))){
    ySum+=yCal;
    zSum+=zCal;
    xSum+=xCal;
    zAbsSum+=abs(zCal);
    yAbsSum+=abs(yCal);
  }else
  {
    if ((yAbsSum)>100)
    _robADXL375_dancingDecode();
    ySum=zAbsSum=yAbsSum=zSum=xSum=0;
    zPicked=yPicked=false;
    frontDirection=0;
    sideDirection=0;
  }
  if ((!zPicked)&&(zSum>=10))
  {
    frontDirection=Backward;
    zPicked=true;
  }
  if ((!zPicked)&&(zSum<=-10))
  {
    frontDirection=Forward;
    zPicked=true;
  }if ((!yPicked)&&(ySum>=10))
  {
    sideDirection=Right;
    yPicked=true;

  }if ((!yPicked)&&(ySum<=-10))
  {
    sideDirection=Left;
    yPicked=true;
  }
}

void _robADXL375_jump()
{
  switch (state)
  {
    case Flat:
      if (rCal>=10)     //  ((analogRead(potPin)<maxADC))                         //  Change these values to theresholds of the rubber reading
      {                                                                           //  A cross over of values to allow debounce
        state=Above;
        first=true;
        sendJumping=InAir;                                                  
        #ifdef ADXL375_JUMPING_SERIAL_PRINT
        Serial.println("In Air"); 
        #endif
      }
      break;
    case Above:
      if (rCal<=1)        //(analogRead(potPin)<minADC)                        //    Potentially change to analogue(read) if the code says "Landed" at bad times.
      {
        state=Flat;
        sendJumping=Landed;
        #ifdef ADXL375_JUMPING_SERIAL_PRINT
        Serial.println("Landed"); 
        Serial.println();Serial.println();Serial.println();
        #endif
      }else if (first&&(xSum>=100))
      {
        sendJumping=Jumping;
        #ifdef ADXL375_JUMPING_SERIAL_PRINT
        Serial.println("Jumping"); 
        #endif
        first=false;
      }
      break;    
  }
}

void _robADXL375_setup() {
  Serial.begin(115200); // Initiate serial communication for printing the results on the Serial monitor
  Wire.begin(); // Initiate the Wire library
  // Set ADXL375 in measuring mode
  Wire.beginTransmission(ADXL375); // Start communicating with the device 
  Wire.write(0x2D); // Access/ talk to POWER_CTL Register - 0x2D
  // Enable measurement
  Wire.write(8); // (8dec -> 0000 1000 binary) Bit D3 High for measuring enable 
  Wire.endTransmission();
  delay(10);
  state =Flat;
}
void _robADXL375_reading() {
  // === Read acceleromter data === //
  Wire.beginTransmission(ADXL375);
  Wire.write(0x32); // Start with register 0x32 (ACCEL_XOUT_H)
  Wire.endTransmission(false);
  Wire.requestFrom(ADXL375, 6, true); // Read 6 registers total, each axis value is stored in 2 registers
  xRaw = ( Wire.read()| Wire.read() << 8); // X-axis value
  yRaw = ( Wire.read()| Wire.read() << 8); // Y-axis value
  zRaw = ( Wire.read()| Wire.read() << 8); // Z-axis value

  xCal = xRaw+ xCalibrated;                                     //
  yCal = yRaw + yCalibrated;                                    //      Remember to change the calibration values
  zCal= zRaw+zCalibrated;                                       //      for each croc!
  rCal=sqrt(pow(xCal,2)+pow(yCal,2)+pow(zCal,2));

  #ifdef ADXL375_CALIBRATE
  Serial.println();                   //    Used for debugging
  Serial.print(xRaw);
  Serial.print(",");
  Serial.print(yRaw);
  Serial.print(",");
  Serial.print(zRaw);
  #else
  _robADXL375_dancing();
  _robADXL375_jump();
  #endif

  #ifdef ADXL375_DEBUG_PRINT

  Serial.println();                   //    Used for debugging
  Serial.print(xCal);
  Serial.print(",");
  Serial.print(yCal);
  Serial.print(",");
  Serial.print(zCal);
  Serial.print(",");
  Serial.print(rCal);
  Serial.print(",");
  Serial.print(xSum);
  Serial.print(",");
  Serial.print(ySum);
  Serial.print(",");
  Serial.print(zSum);
  Serial.print(",");
  
  #endif


  delay(25);
}
