//
//        Base I2C code for interaction taken from 
//        https://howtomechatronics.com/tutorials/arduino/how-to-track-orientation-with-arduino-and-adxl345-accelerometer/
//        
//        And then adapted to work with ADXL375
//   
// 
//        Sending unit8 00000011  Forwards
//                      00001100  Backwards 
//                      00110000  Right
//                      11000000  Left
//
//
//        Once there is a resultant accelration, the code checks for both sideways and front ways, which is the leading "Velocity" (sum).
//        Once the movement stops, it calculates which direction had the "most speed" (sum of absolute of acceleration). It then picks
//        which movement to send.
//
//        The sendDirection is NOT reset and may need to be for bluetooth.
//
//
//                  █████████▀██████████████████████████████
//                  █████████▀██████████████████████████████
//                  █████████▀██████████████████████████████
//                  ████████▀▀██████████████████████████████
//                  ███████▀▀▀██████████████████████████████
//                  ███████▀▀▀▀█████████████████████████████
//                  ███████▀▀▀▀█████████████████████████████
//                  ███████▀▀▀▀█████████████████████████████
//                  ███████▀▀▀▀██████████████████▀▀▀████████
//                  ████████▀▀▀█████████████████▀▀▀▀▀███████
//                  ████████▀▀▀▀███████████████▀▀▀▀▀▀▀██████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀█████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀████████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀▀███████████████▀▀▀▀▀▀▀▀████
//                  ████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀█████▀▀▀▀▀▀▀▀████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀██▀▀▀▀▀▀▀█████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀██████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀███████
//                  █████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀████████
//                  █████████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀███████
//                  █████████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀█████
//                  ████████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀████
//                  ███████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀███
//                  ██████████████▀▀▀▀▀▀▀▀▀▀▀▀▀▀███▀▀▀▀▀▀▀██
//                  █████████████▀▀▀▀▀▀▀▀▀▀▀▀███████▀▀▀▀▀▀▀█
//                  █████████████▀▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀
//                  █████████████▀▀▀▀▀▀▀▀██████████████▀▀▀▀▀
//                  ████████████▀▀▀▀▀▀▀███████████████▀▀▀▀▀▀
//                  ████████████▀▀▀▀▀▀▀█████████████▀▀▀▀▀▀▀▀
//                  ████████████▀▀▀▀▀▀▀████████████▀▀▀▀▀▀▀▀█
//                  ████████████▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀▀▀█
//                  ████████████▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀▀███
//                  ███████████▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀▀████
//                  ██████████▀▀▀▀▀▀▀▀███████▀▀▀▀▀▀▀█▀▀█████
//                  █████████▀▀▀▀▀▀▀▀▀██████▀▀▀▀▀▀▀▀████████
//                  ███████▀▀▀▀▀▀▀▀▀▀▀▀█████████████████████
//                  ██████▀▀▀▀▀▀▀▀▀▀▀▀▀█████████████████████
//                  █████▀▀▀▀▀▀▀▀█▀▀▀▀▀▀████████████████████
//                  ████▀▀▀▀▀▀▀▀███▀▀▀▀▀▀███████████████████
//                  ███▀▀▀▀▀▀▀▀████▀▀▀▀▀▀▀██████████████████
//                  ██▀▀▀▀▀▀▀▀██████▀▀▀▀▀▀▀█████████████████
//                  █▀▀▀▀▀▀▀█████████▀▀▀▀▀▀█████████████████
//                  ▀▀▀▀▀▀▀███████████▀▀▀▀▀▀████████████████
//                  ▀▀▀▀▀▀████████████▀▀▀▀▀▀▀███████████████
//                  ▀▀▀▀▀▀▀████████████▀▀▀▀▀▀▀██████████████
//                  ▀▀▀▀▀▀▀▀████████████▀▀▀▀▀▀▀█████████████
//                  █▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀█████████████
//                  █▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀████████████
//                  ██▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀▀███████████
//                  ██▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀███████████
//                  ██▀▀▀▀▀▀▀▀▀███████████▀▀▀▀▀▀▀▀██████████
//                  ███▀▀▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀██████████
//                  ███▀▀▀▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀█████████
//                  ███▀▀▀▀▀▀▀▀▀▀██████████▀▀▀▀▀▀▀▀█████████
//                  ████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀█████████
//                  ████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀▀████████
//                  █████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀████████
//                  █████▀▀▀▀▀▀▀▀▀▀█████████▀▀▀▀▀▀▀▀████████
//                  ██████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀███████
//                  ██████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀███████
//                  ██████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀▀███████
//                  ███████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀███████
//                  ███████▀▀▀▀▀▀▀▀▀▀████████▀▀▀▀▀▀▀▀███████
//                      .-._   _ _ _ _ _ _ _ _
//           .-''-.__.-'00  '-' ' ' ' ' ' ' ' '-.
//          '.___ '    .   .--_'-' '-' '-' _'-' '._
//           V: V 'vv-'   '_   '.       .'  _..' '.'.
//             '=.____.=_.--'   :_.__.__:_   '.   : :
//                     (((____.-'        '-.  /   : :
//                                      (((-'\ .' /
//                                     _____..'  .'
//                                    '-._____.-'


#include "DancingCrocs.hpp"


int16_t xRaw, yRaw, zRaw;  // Outputs

float xCal,yCal,zCal,rCal;

float ySum,zSum;

float yAbsSum,zAbsSum;

uint8_t sendDirection=0;

uint8_t frontDirection = 0;

uint8_t sideDirection=0;

bool zPicked=false;
bool yPicked=false;

void _robADXL375_decode()                   //    Decodes and sends the direction
{
  if (yAbsSum>zAbsSum)
  {
    sendDirection=sideDirection;
    #ifdef ADXL375_SERIAL_PRINT
    if (sideDirection==Left)
    {
    Serial.print("Left");
    }
    else if (sideDirection==Right)
    {
      Serial.print("Right");
    }
    else
    {
      Serial.print("ERROR!! side is ");
      Serial.print(sideDirection);
    }
    #endif
  }
  else
  {  
    sendDirection=sideDirection;                 
    #ifdef ADXL375_SERIAL_PRINT                  
    if (frontDirection==Forward)
    {
    Serial.print("Forward");
    }
    else if (frontDirection==Backward)
    {
      Serial.print("Backward");
    }
    else
    {
      Serial.print("ERROR!! front is ");
      Serial.print(frontDirection);
    }
    
    #endif
  }

}

void _robADXL375_setup() {
  Serial.begin(115200); // Initiate serial communication for printing the results on the Serial monitor
  Wire.begin(); // Initiate the Wire library
  // Set ADXL375 in measuring mode
  Wire.beginTransmission(ADXL375); // Start communicating with the device 
  Wire.write(0x2D); // Access/ talk to POWER_CTL Register - 0x2D
  // Enable measurement
  Wire.write(8); // (8dec -> 0000 1000 binary) Bit D3 High for measuring enable 
  Wire.endTransmission();
  delay(10);
}
void _robADXL375_reading() {
  // === Read acceleromter data === //
  Wire.beginTransmission(ADXL375);
  Wire.write(0x32); // Start with register 0x32 (ACCEL_XOUT_H)
  Wire.endTransmission(false);
  Wire.requestFrom(ADXL375, 6, true); // Read 6 registers total, each axis value is stored in 2 registers
  xRaw = ( Wire.read()| Wire.read() << 8); // X-axis value
  yRaw = ( Wire.read()| Wire.read() << 8); // Y-axis value
  zRaw = ( Wire.read()| Wire.read() << 8); // Z-axis value
  xCal = xRaw+xCalibrated;
  yCal = yRaw + yCalibrated;
  zCal= zRaw+zCalibrated;
  rCal=sqrt(pow(xCal,2)+pow(yCal,2)+pow(zCal,2));

  if ((rCal>3) || ((yAbsSum>100)&&(rCal>1.5))){
    ySum+=yCal;
    zSum+=zCal;
    zAbsSum+=abs(zCal);
    yAbsSum+=abs(yCal);
  }else
  {
    if ((yAbsSum)>100)
    _robADXL375_decode();
    ySum=zAbsSum=yAbsSum=zSum=0;
    zPicked=yPicked=false;
    frontDirection=0;
    sideDirection=0;
  }
  if ((!zPicked)&&(zSum>=10))
  {
    frontDirection=Backward;
    zPicked=true;
  }
  if ((!zPicked)&&(zSum<=-10))
  {
    frontDirection=Forward;
    zPicked=true;
  }if ((!yPicked)&&(ySum>=10))
  {
    sideDirection=Right;
    yPicked=true;

  }if ((!yPicked)&&(ySum<=-10))
  {
    sideDirection=Left;
    yPicked=true;
  }
  

  #ifdef ADXL375_DEBUG_PRINT

  Serial.println();                   //    Used for debugging
  Serial.print(ySum);
  Serial.print(",");
  Serial.print(zSum);
  Serial.print(",");
  Serial.print(yAbsSum);
  Serial.print(",");
  Serial.print(zAbsSum);
  Serial.print(",");
  
  #endif


  delay(25);
}