//
//        Base I2C code for interaction taken from 
//        https://howtomechatronics.com/tutorials/arduino/how-to-track-orientation-with-arduino-and-adxl345-accelerometer/
//        
//        And then adapted to work with ADXL375
//
//
//        Calculates a jump as going above 50 after going below -30. And then returning to a flat value after going back below -30. 
//                                                                                   _
//        Uses a state machine to ensure values follow the following cycle          / \
//                                                                           __    /   \   ___   
//                                                                              \_/     \_/
//                                                                                          ^ Jump ended
//                                                                                   ^Jump activeate
//        Sets a bool during the "In air time", and then turned of when "landed" in flat.
//        
//        Uses resultant to make sure a false flat line is prodcued.
// 

#include "CrocsJump.hpp"

static unsigned int state;      //    State machine of 4 states Flat,First Below,above second below. 
//                                    This was needed to make sure each jump didn't count as two.

int16_t xRaw, yRaw, zRaw;  // Outputs

float xCal,yCal,zCal,rCal;

bool Jump;                      //  Used to talk to rest of app


#ifdef ADXL375_DEBUG_PRINT
bool first=true;
#endif


void _robADXL375_setup() {
  Serial.begin(115200); // Initiate serial communication for printing the results on the Serial monitor
  Wire.begin(); // Initiate the Wire library
  // Set ADXL375 in measuring mode
  Wire.beginTransmission(ADXL375); // Start communicating with the device 
  Wire.write(0x2D); // Access/ talk to POWER_CTL Register - 0x2D
  // Enable measurement
  Wire.write(8); // (8dec -> 0000 1000 binary) Bit D3 High for measuring enable 
  Wire.endTransmission();
  delay(10);
  state =Flat;
}
void _robADXL375_reading() {
  // === Read acceleromter data === //
  Wire.beginTransmission(ADXL375);
  Wire.write(0x32); // Start with register 0x32 (ACCEL_XOUT_H)
  Wire.endTransmission(false);
  Wire.requestFrom(ADXL375, 6, true); // Read 6 registers total, each axis value is stored in 2 registers
  xRaw = ( Wire.read()| Wire.read() << 8); // X-axis value
  yRaw = ( Wire.read()| Wire.read() << 8); // Y-axis value
  zRaw = ( Wire.read()| Wire.read() << 8); // Z-axis value
  xCal = xRaw+xCalibrated;
  yCal = yRaw + yCalibrated;
  zCal= zRaw+zCalibrated;
  rCal=sqrt(pow(xCal,2)+pow(yCal,2)+pow(zCal,2));

  #ifdef ADXL375_DEBUG_PRINT

  Serial.println();                   //    Used for debugging
  Serial.print(xCal);

  Serial.print(",");
  Serial.print(yCal);
  Serial.print(",");
  Serial.print(zCal);
  Serial.print(",");
  Serial.print(rCal);
  Serial.print(",");
  #endif

  switch (state)
  {
    case Flat:
      state=(xCal<=-30)?FirstBelow:Flat;
      #ifdef ADXL375_DEBUG_PRINT
      first=true;                                   
      #endif                                            
      Jump=false;
      break;
    case FirstBelow:
      state=(xCal>=50)?Above:FirstBelow;
      break;
    case Above:
      state=(xCal<=-30)?SecondBelow:Above;
      Jump=true;
      #ifdef ADXL375_DEBUG_PRINT
      if (first){
        Serial.print("In air");
        first=false;
      }
      #endif
      break;
    case SecondBelow:   
      state=(rCal<=2)?Flat:SecondBelow;
      break;
  }
  delay(10);
}