//
//        Base I2C code for interaction taken from 
//        https://howtomechatronics.com/tutorials/arduino/how-to-track-orientation-with-arduino-and-adxl345-accelerometer/
//        
//        And then adapted to work with ADXL375
//
//
//        Sending unit8 00000011  Forwards
//                      00001100  Backwards 
//                      11110000  Sideways
//  
//        When you put croc down first time, just record the y,z values for like 100 and then create an average.
//        Then change the cal number to try centre this number.
//  
//        It will be unlikely it will work withough adapting the numbers again.
//
//

#include "Crocs.hpp"

bool step=false;          //  Checks if a step has been done.

int direction=0;        //Used for internal detection . Can definitely be improved.
//                             [ {-1 = Left  +1 = Right },{+1 = Backward   -1  = Forward}]

uint8_t sentByte=0;         //  3 = Front , 12 = Backward , 240 = Sideways

float ySum=0;               //  Sum of Y values in current step
float yAbsSum=0;            //  Sum of absolute Y values in current step

float zSum=0;               //  Sum of Z values in current step
float zAbsSum=0;            //  Sum of absolute Z values in current step

float zSumAbsSum=0;
float ySumAbsSum=0;

bool yPicked=false;         //  Bool if X direction has been determined
bool zPicked=false;         //  Bool if X direction has been determined

int8_t xRaw, yRaw, zRaw;      //  Read in value of raw acceleration values

float yCal,zCal;              //    Numbers to "calabrate"

void _robADXL375_setup(){
  Serial.begin(115200); // Initiate serial communication for printing the results on the Serial monitor
  Wire.begin(); // Initiate the Wire library
  // Set ADXL375 in measuring mode
  Wire.beginTransmission(ADXL375); // Start communicating with the device 
  Wire.write(0x2D); // Access/ talk to POWER_CTL Register - 0x2D
  // Enable measurement
  Wire.write(8); // (8dec -> 0000 1000 binary) Bit D3 High for measuring enable 
  Wire.endTransmission();
  delay(100);
  
  

}

void _robADXL375_readAccel(){
  // === Read acceleromter data === //
  Wire.beginTransmission(ADXL375);
  Wire.write(0x32); // Start with register 0x32 (ACCEL_XOUT_H)
  Wire.endTransmission(false);
  Wire.requestFrom(ADXL375, 6, true); // Read 6 registers yRaw, each axis value is stored in 2 registers
  xRaw = ( Wire.read()| Wire.read() << 8); // X-axis value
  yRaw = ( Wire.read()| Wire.read() << 8); // Y-axis value
  zRaw = ( Wire.read()| Wire.read() << 8); // Z-axis value
  
  yCal=yRaw-4.490111471;            //  Change these numbers
  zCal=zRaw-3.646889608;

  ySum=yCal+ySum;
  zSum=zCal+zSum;
  yAbsSum=abs(yCal)+yAbsSum;
  zAbsSum=abs(zCal)+zAbsSum;
  zSumAbsSum+=zAbsSum;
  ySumAbsSum+=yAbsSum;

  if ((ySum>25)&&!yPicked)          //  These numbers probably need to be recalibrated
  { 
    direction =F;
    yPicked=true;
  }else if ((ySum<-25)&&!yPicked)
  {
    direction =B;
    yPicked=true;
  }


  #ifdef  ADXL375_DEBUG_PRINT 

  Serial.println();
  Serial.print(yCal);Serial.print(",");
  Serial.print(zCal);Serial.print(",");
  Serial.print(ySum);Serial.print(",");
  Serial.print(zSum);Serial.print(",");
  Serial.print(yAbsSum);Serial.print(",");
  Serial.print(zAbsSum);Serial.print(",");
  Serial.print(ySumAbsSum);Serial.print(",");
  Serial.print(zSumAbsSum);Serial.print(",");

  #endif


}

void _robADXL375_decode()
{
  if (((ySumAbsSum>=zSumAbsSum)&&(ySumAbsSum>=300)))
  {
    if (direction==F)               
    {
      Serial.println("Forwards");
	    sentByte=Forwards;       				  
    }
    else if(direction==B)
    {
      Serial.println("Backwards");
	    sentByte=Backwards;         			
    }
  }
  else if ((ySumAbsSum>=300))
  {
    Serial.println("Sideways");
    sentByte=Sideways;
  }
}

void _robADXL375_clear()
{                           //  Clears all the variables. Theres definitely a better way of doing this.
  ySum=0;
  zSum=0;
  yAbsSum=0;
  zAbsSum=0;
  zSumAbsSum=0;
  zSumAbsSum=0;
  direction=0;
  //sentByte =0;                    //    Not sure if should be reset here or bluetooth does this.
  yPicked=false;
  step=false;
}

void _robADXL375_loop(){
  while (analogRead(potPin)>=maxADC){          //  While the foot is in the air, record values.
    _robADXL375_readAccel();                              //  To be tuned to the rubber values
    delay(10);
    step=true;                                //  Tells a step has taken place so will decoded and clear once.
  }
  while(((analogRead(potPin)<maxADC))&&(analogRead(potPin)>minADC))
  {}
  if(step){                                   //  Decodes and clears once a single step has taken place.
    _robADXL375_decode();
	  delay(10);
    _robADXL375_clear();
    
  }  
  delay(10);

}