#ifndef HEADER_SERVICEINFO_H
#define HEADER_SERVICEINFO_H

#include <QtBluetooth/QLowEnergyService>
#include <QObject>

class ServiceInfo: public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString serviceName READ getName NOTIFY serviceChanged)
    Q_PROPERTY(QString serviceUuid READ getUuid NOTIFY serviceChanged)
    Q_PROPERTY(QString serviceType READ getType NOTIFY serviceChanged)
    public:
        ServiceInfo() = default;
        ServiceInfo(QLowEnergyService *service);
        QLowEnergyService *service() const;
        QString getUuid() const;
        QString getName() const;
        QString getType() const;

    signals:
        void serviceChanged();

    private:
        QLowEnergyService *m_service = nullptr;
};

#endif
