#ifndef HEADER_DEVICEINFO_H
#define HEADER_DEVICEINFO_H

#include <qbluetoothdeviceinfo.h>
#include <qbluetoothaddress.h>
#include <QList>
#include <QObject>

enum DeviceType {
    Wristwatch = 0,
    CrocsLeft = 1,
    CrocsRight = 2,
    BoxingGloveLeft = 3,
    BoxingGloveRight = 4
};

class DeviceInfo : public QObject
{
    Q_OBJECT
    public:
        DeviceInfo() = default;
        DeviceInfo(const QBluetoothDeviceInfo &device);
        QString getAddress();
        QString getName();
        QBluetoothDeviceInfo getDevice();
        void setDevice(const QBluetoothDeviceInfo &dev);
        DeviceType devType;
        bool connected;

    private:
        QBluetoothDeviceInfo currentDevice;

    signals:
        void deviceChanged();
};

#endif
