#include <qbluetoothuuid.h>

#include "deviceInfo.h"


DeviceInfo::DeviceInfo(const QBluetoothDeviceInfo &device){
    this->currentDevice = device;
}

QString DeviceInfo::getAddress()
{
#ifdef Q_OS_MAC
    //Macs and ios dont have address so return uuid
    return currentDevice.deviceUuid().toString();
#else
    return currentDevice.address().toString();
#endif
}

QString DeviceInfo::getName() 
{
    return currentDevice.name();
}

QBluetoothDeviceInfo DeviceInfo::getDevice()
{
    return currentDevice;
}

void DeviceInfo::setDevice(const QBluetoothDeviceInfo &dev)
{
    currentDevice = QBluetoothDeviceInfo(dev);
    emit deviceChanged();
}
