#ifndef HEADER_CHARACTERISTICINFO_H
#define HEADER_CHARACTERISTICINFO_H
#include <QObject>
#include <QString>
#include <QtBluetooth/QLowEnergyCharacteristic>

class CharacteristicInfo: public QObject
{
    Q_OBJECT
    public:
        CharacteristicInfo() = default;
        CharacteristicInfo(const QLowEnergyCharacteristic &characteristic);
        void setCharacteristic(const QLowEnergyCharacteristic &characteristic);
        QString getName() const;
        QString getUuid() const;
        QString getValue() const;
        QString getHandle() const;
        QString getPermission() const;
        QLowEnergyCharacteristic getCharacteristic() const;

    Q_SIGNALS:
        void characteristicChanged();

    private:
        QLowEnergyCharacteristic m_characteristic;
    };

#endif // CHARACTERISTICINFO_H
