#include <QObject>
#include <QList>
#include <qbluetoothlocaldevice.h>
#include <QObject>
#include <QVariant>
#include <QList>
#include <QBluetoothServiceDiscoveryAgent>
#include <QBluetoothDeviceDiscoveryAgent>
#include <QLowEnergyController>
#include <QBluetoothServiceInfo>
#include <qqml.h>
#include "deviceInfo.h"
#include "charInfo.h"
#include "serviceInfo.h"

// struct GpsDataFrame{
//     unsigned char test1;
//     unsigned char test2;
//     unsigned char test3;
//     unsigned char test4;
// };

class BleController : public QObject
{
    Q_OBJECT

    QML_ELEMENT
    public:
        QString wristwatchServiceUUID = "9c234f41-3a33-4179-a7a8-ef365241e45d";
        QString wristwatchGpsCharUUID = "3d4512a1-e027-473d-b880-f58e75ad8a9e";
        QString wristwatchStepCharUUID = "5609996a-8003-4f11-bd73-8ae0eee8d004";
        QString wristwatchWalkingGameToggleCharUUID = "dd914d0c-5c07-432d-8a59-ba13be008539";
        QString wristwatchRunningGameToggleCharUUID = "6d298f83-7002-4f93-beb3-0232eacca220";
        QString wristwatchMindfulnessGameToggleCharUUID = "e3b370c4-137c-4538-b79d-2eac94e41e6c";
        QString boxingGloveBoxingGameToggleCharUUID = "3f7316ce-2120-441a-a4d9-2dec515851eb";
        QString crocsDancingGameToggleCharUUID = "64016a6d-987d-4c7c-8ead-5a818c1a4bf9";
        QString wristwatchHeartCharUUID = "50787168-dec5-437c-a6ab-e52fa492c85c";
        QString crocsLeftServiceUUID = "5454849d-6f8c-41fe-af7d-b0388099b98e";
        QString crocsRightServiceUUID = "a4e9dd87-b8d9-44ef-928b-2beffeac0cdc";
        QString crocsAccelerometerCharUUID = "cff7b61a-66fc-407b-b02c-7887c20d9382";
        QString boxingGloveLeftServiceUUID = "b844f731-dc3a-463a-a67a-e45acc03ceb8";
        QString boxingGloveRightServiceUUID = "1f8afcfa-1cd0-46e4-b042-4bc8a2b7b783";
        QString boxingGlovePunchCounterCharUUID = "f4c00485-1f79-4ce7-90ed-5e4740adc8c2";
        QString wristwatchInfo = "This wristwatch device implements GPS, Step counter and heart rate sensor";
        QString crocsInfo = "This croc implements an accelerometer to be used in the dancing game";
        QString boxingInfo = "This boxing glove implements accelerometer to be used in the boxing game";
        BleController();
        ~BleController();
        QVariant getDevices();
        QVariant getServices();
        QString getUpdate();
        bool isRandomAddress();


    private:
        QBluetoothDeviceDiscoveryAgent *discoveryAgent;
        // DeviceInfo currentDevice;
        QList<ServiceInfo*> initialScannedServices;
        QList<DeviceInfo *> scannedDevices;
        QList<ServiceInfo*> scannedServices[5];
        ServiceInfo *finalScannedServices[5];
        QList<CharacteristicInfo*> scannedCharacteristics[5];
        QString m_previousAddress;
        QString m_message;
        bool connected = false;
        QLowEnergyController *initialScanController = nullptr;
        // QLowEnergyController *wristwatchController= nullptr;
        // QLowEnergyController *crocsLeftController = nullptr;
        // QLowEnergyController *crocsRightController = nullptr;
        // QLowEnergyController *boxingGloveLeftController= nullptr;
        // QLowEnergyController *boxingGloveRightController= nullptr;
        QLowEnergyController *controllers[5];
        QString wristbandBtName = "Wristband";
        QString boxingGlovesBtName = "BoxingGloves";
        QString crocsLeftControllerBtName = "Crocs-L";
        QString crocsRightControllerBtName = "Crocs-R";
        bool m_deviceScanState = false;
        bool randomAddress = false;
        DeviceInfo initialScanTempDevice;
        QList <DeviceInfo *> pairedDevices;
        QList <DeviceInfo *> currentlyConnectedDevices;
        void startServiceScan(int devType, DeviceInfo *currentDevice);
        void setUpCharacteristicTracking(QLowEnergyService *service, int devType);
        void onCharacteristicChanged(QLowEnergyCharacteristic characteristic, QByteArray newVal, int devType);
        void toggleGameCharacteristic(int devType, int gameType, bool gameState);

    public slots:
        int startDeviceScan();
        void startInitialServiceScan(int index);
        void connectToMainService(ServiceInfo *serviceInfo, int devType);
        void setDeviceAsPaired(int index);
        void connectToPairedDevice(int devType);
        bool getPairedDeviceConnectionStatus(int devType);
        QString getDeviceInfo(int devType);
        void unpairDevice(int devType);
        void disconnectDevice(int devType);

        //DEVICE SLOTS
        //BOXING GAME (boxing gloves)
        void startBoxingGame();
        void stopBoxingGame();

        //WALKING GAME (wristwatch)
        void startWalkingGame();
        void stopWalkingGame();

        //RUNNING GAME (wristwatch)
        void startRunningGame();
        void stopRunningGame();

        //DANCING GAME (crocs)
        void startDancingGame();
        void stopDancingGame();

        //TESTING FUNCTIONS FOR QML GAME DEVELOPMENT
        void emitLeftPunchDetected(bool isJab,bool isChop, bool isUppercut);
        void emitRightPunchDetected(bool isJab,bool isChop, bool isUppercut);
        void emitHeartRateDataRecieved(int heartRate);
        void emitStepDataRecieved(int stepsNum);
        void emitGpsDataRecivied(double distanceInMeters);

        //FUNCTIONS TO CHECK IF DEVICE IS CONNECTED
        bool checkWristwatchConnected();
        bool checkLeftCrocConnected();
        bool checkRightCrocConnected();
        bool checkLeftBoxingGloveConnected();
        bool checkRightBoxingGloveConnected();


    private slots:
        void addNewDevice(const QBluetoothDeviceInfo&);
        void scanDone();
        void scanError(QBluetoothDeviceDiscoveryAgent::Error);
        void initialServiceScanDeviceConnected();
        void initialServiceScanErrorRecieved(QLowEnergyController::Error);
        void initialServiceScanDeviceDisconnected();
        void initialServiceScanAddLowEnergyService(const QBluetoothUuid &uuid);
        void initialServiceScanDone();
        void serviceScanDeviceConnected(int devType);
        void serviceScanErrorRecieved(QLowEnergyController::Error, int devType);
        void serviceScanDeviceDisconnected(int devType);
        void serviceScanAddLowEnergyService(const QBluetoothUuid &serviceUuid, int devType);
        void serviceScanDone(int devType);
        void serviceDetailsDiscovered(QLowEnergyService::ServiceState newState, int devType);


    signals:
        void deviceListUpdated();
        void stateChanged(bool newState);
        void updateChanged();
        void characteristicsUpdated();
        void servicesUpdated();
        void disconnectedFromInitialScanDevice();
        void disconnectFromDevice(int devType);
        void newDeviceAdded(int index, QString name);
        void scanErrorSignal(QString errString);
        void pairedWithDevice(int devType, QString devName);
        void pairedDeviceConnectionStatusChanged(int devType, int newConnStatus);

        //SIGNALS WHEN NEW DEVICE DATA IS DETECTED
        //WRISTWATCH
        void gpsDataRecieved(double distanceInMeters);
        void stepDataRecieved(int stepsNum);
        void heartRateDataRecieved(int heartRateBPM);
        void onWristwatchDisconnected();

        //CROCS
        void leftCrocAccelerometerDataRecieved(bool isFront, bool isBack, bool isRight, bool isLeft);
        void rightCrocAccelerometerDataRecieved(bool isFront, bool isBack, bool isRight, bool isLeft);
        void onLeftCrocDisconnected();
        void onRightCrocDisconnected();


        //BOXING GLOVE
        void leftPunchDetected(bool isJab, bool isChop, bool isUppercut);
        void rightPunchDetected(bool isJab, bool isChop, bool isUppercut);
        void onLeftBoxingGloveDisconnected();
        void onRightBoxingGloveDisconnected();








};
