import QtQuick 2.5
import QtQuick.Controls 2.15
import Furlough 1.0

Item {
    id: item1
    //width: 1200
    //height: 1920
    property alias bleControllerReference: bleController

    Rectangle {
        id: background
        visible: true
        color: "#3c3744"
        anchors.fill: parent
    }

    FontLoader { id: robotoFont; source: "../../resources/Roboto-Thin.ttf" }


    BleController {
        id: bleController
    }

    //HANDLER FUNCTIONS
    function stateChangedHandler(newState){
        console.log("scanning state changed")
        scanningIconAnimation.visible = true
        if(newState){
            scanningIconAnimation.visible = true
        }else{
            scanningIconAnimation.visible = false
        }
    }

    function newDeviceAddedHandler(deviceIndex, deviceName){
        console.log("New device added. Index: " + deviceIndex + " Name: " + deviceName)
        var deviceIndexStr = parseInt(deviceIndex)
        scannedDevicesListModel.append({"name":deviceName})
        scannedDevicesListModel.setProperty(deviceIndex,"currentIndex",deviceIndex)

    }

    function displayWarningHandler(warningStr){
        console.log("Displaying a warning")
        warningPanel.visible = true
        warningText.text = warningStr
    }

    function devicePairedHandler(devType, devName){
        console.log("Pairing a new device")
        deviceScanPanel.visible = false
        pairedDevicesListModel.append({"deviceName":devName, "devType":devType})
        // pairedDevicesListModel.setProperty()
    }

    function displayDeviceInfo(devType, connectionStatus, description){
        console.log("Displaying device info");
        if(connectionStatus){
            connectedStatusYesImage.visible = true;
            connectedStatusNoImage.visible = false;
        }else{
            connectedStatusNoImage.visible = true;
            connectedStatusYesImage.visible = false;
        }
        connectionStatusRect.currentDevType = devType;
        deviceDescription.text = bleController.getDeviceInfo(devType);


    }

    function disconnectedFromDeviceHandler(devType){
        console.log("Disconnected handler");
        if(devType===connectionStatusRect.currentDevType){
            console.log("Disconnected handler for current device");
            connectedStatusNoImage.visible = true;
            connectedStatusYesImage.visible = false;
        }
    }

    function unpairDevice(devType){
        bleController.unpairDevice(devType);
    }


    RoundButton {
        id: pairingButton
        x: (parent.width/2 - width/2)
        width: height
        height: parent.height * 0.1
        radius: 60
        text: qsTr("Pair a new device")
        anchors.top: parent.top
        highlighted: false
        flat: false
        font.styleName: "Thin"
        display: AbstractButton.IconOnly
        font.family: "Roboto"
        anchors.topMargin: parent.height*0.05

        background: Rectangle {
            radius: pairingButton.radius
            color: "#bf497db6"
        }

        Component.onCompleted: {
            console.log("Initializing handlers")
            bleController.stateChanged.connect(stateChangedHandler)
            bleController.newDeviceAdded.connect(newDeviceAddedHandler)
            bleController.scanErrorSignal.connect(displayWarningHandler)
            bleController.pairedWithDevice.connect(devicePairedHandler)
            bleController.disconnectFromDevice.connect(disconnectedFromDeviceHandler)
        }
        onClicked:{
            console.log(bleController.startDeviceScan())
            deviceScanPanel.visible = true

        }

        Image {
            id: image
            anchors.fill: parent
            source: "../../resources/connection-icon.png"
            anchors.rightMargin: 12
            anchors.leftMargin: 12
            anchors.bottomMargin: 12
            anchors.topMargin: 12
            fillMode: Image.PreserveAspectFit
        }
    }

    Rectangle {
        id: descriptionPanel
        x: parent.width/2 - width/2
        width: parent.width*0.9
        //y:
        height: parent.height*0.3
        visible: true
        color: "#00ffffff"
        anchors.bottom: parent.bottom
        anchors.bottomMargin: parent.height*0.05

        Rectangle {
            id: deviceDescriptionLabelRect
            x: parent.width/2 - width/2
            y: parent.y + parent.height
            width: parent.width
            height: parent.height*0.2
            color: "#b3000000"
            radius: 69
            border.width: 0
            anchors.top: parent.top
            anchors.topMargin: 0

            Text {
                id: deviceDescriptionLabel
                color: "#ffffff"
                text: qsTr("Device description:")
                anchors.fill: parent
                font.pixelSize: 42
                font.family: "Roboto"
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                anchors.rightMargin: 0
                anchors.leftMargin: 0
                anchors.topMargin: 0
                anchors.bottomMargin: 0
                //minimumPointSize: 57
                //minimumPixelSize: 57
                fontSizeMode: Text.Fit
            }
        }

        Rectangle {
            id: deviceDescriptionRect
            x: parent.width/2 - width/2
            //anchors.bottom: parent.bottom
            width: parent.width
            height: parent.height*0.8
            color: "#b3282828"
            radius: 33
            anchors.bottomMargin: parent.height*0.1
            z: -10

            Text {
                id: deviceDescription
                height: parent.height*0.4
                color: "#ffffff"
                text: qsTr("")
                anchors.left: parent.left
                anchors.right: parent.right
                anchors.bottom: parent.bottom
                font.pixelSize: 20
                wrapMode: Text.Wrap
                font.family: "Roboto"
                anchors.rightMargin: 30
                anchors.leftMargin: 30
                anchors.bottomMargin: 10
                fontSizeMode: Text.Fit
            }

            Rectangle {
                id: connectionStatusRect
                property int currentDevType
                x: 0
                width: parent.width
                height: parent.height*0.2
                visible: true
                color: "#0dffffff"
                radius: 21
                border.color: "#00000000"
                anchors.top: parent.top
                anchors.topMargin: parent.height*0.3

                Image {
                    id: connectedStatusYesImage
                    width:parent.height
                    height: parent.height
                    visible: false
                    anchors.left: parent.left
                    anchors.top: parent.top
                    source: "../../resources/connected-icon-1.png"
                    anchors.leftMargin: 15
                    anchors.topMargin: 0
                    fillMode: Image.PreserveAspectFit
                }

                Image {
                    id: connectedStatusNoImage
                    width: parent.height
                    height: parent.height
                    visible: false
                    anchors.left: parent.left
                    anchors.top: parent.top
                    source: "../../resources/not-connected-icon-1.png"
                    anchors.leftMargin: 15
                    fillMode: Image.PreserveAspectFit
                    anchors.topMargin: 0
                }
            }
        }

    }

    Rectangle {
        id: pairedDevicesListRect
        x: (parent.width/2 - width/2)
        width: parent.width*0.8
        height: parent.height*0.4
        visible: true
        color: "#b3282828"
        radius: 33
        anchors.top: parent.top
        anchors.topMargin: parent.height*0.2

        ListView {
            id: pairedDevicesList
            anchors.fill: parent
            anchors.bottomMargin: 21
            anchors.leftMargin: 0
            anchors.rightMargin: 0
            anchors.topMargin: 21
            //property int devTypeProperty: devType
            delegate: Item {
                x: 0
                width: pairedDevicesList.width
                height: pairedDevicesList.height*0.2
                Rectangle {
                    width: parent.width
                    height: parent.height*0.2
                    color: "transparent"
                }
                Rectangle{
                    width: parent.width
                    height: parent.height*0.8
                    color: "#2F4c4ceb"
                    Text {
                        text: deviceName
                        color: "white"
                        anchors.verticalCenter: parent.verticalCenter
                        font.bold: true
                    }
                    MouseArea {
                        anchors.fill: parent
                        onClicked: {
                            console.log("Displaying device info for DevType: "+ devType)
                            //bleController.connectToPairedDevice(devType);
                            displayDeviceInfo(devType,bleController.getPairedDeviceConnectionStatus(devType));
                        }
                    }
                    RoundButton{
                        width: parent.height*0.8
                        height: parent.height*0.8
                        anchors.right: parent.right
                        anchors.rightMargin: parent.width*0.05
                        radius: 5
                        background: Rectangle{
                            color: "red"
                            radius: 15
                        }
                        onClicked: {
                            //console.log("Unpairing a device");
                            //unpairDevice(devType);
                            //pairedDevicesListModel.remove(index);
                            console.log("Disconnecting from DevType: " +devType)
                            bleController.disconnectDevice(devType);
                        }

                    }
                    RoundButton{
                        width: parent.height*0.8
                        height: parent.height*0.8
                        anchors.right: parent.right
                        anchors.rightMargin: parent.width*0.2
                        radius: 5
                        background: Rectangle{
                            color: "green"
                            radius: 15
                        }
                        onClicked: {
                            console.log("Connecting to DevType: "+ devType)
                            bleController.connectToPairedDevice(devType);
                            displayDeviceInfo(devType,bleController.getPairedDeviceConnectionStatus(devType));
                        }

                    }
                }
            }
            model: pairedDevicesListModel
        }
    }

    ListModel {
        id: pairedDevicesListModel
        //ListElement {
        //    deviceName: "TestDev"
        //    devType: 5
        //}

    }

    Rectangle {
        id: deviceScanPanel
        visible: false
        color: "#e6373737"
        radius: 42
        border.width: 6
        anchors.fill: parent
        anchors.bottomMargin: 66
        anchors.leftMargin: 66
        anchors.rightMargin: 60
        anchors.topMargin: 84

        Rectangle {
            id: scanningIcon
            width: parent.width*0.2
            height: parent.width*0.2
            color: "transparent"
            border.width: 0
            anchors.left: parent.left
            anchors.top: parent.top
            anchors.leftMargin: parent.width * 0.05
            anchors.topMargin: parent.height * 0.2

            AnimatedImage { id: scanningIconAnimation; visible: false; anchors.fill: parent; source: "../../resources/loadingIcon.gif" ; }
        }

        Rectangle {
            id: scannedDevicesLabelRect
            x: 0
            y: 0
            width: parent.width
            height: parent.height*0.15
            color: "#b3646464"
            radius: 39
            border.width: 6

            Text {
                id: scannedDevicesLabel
                visible: true
                color: "#000000"
                text: qsTr("SCAN")
                anchors.fill: parent
                font.pixelSize: 20
                font.family: robotoFont.name
                horizontalAlignment: Text.AlignHCenter
                verticalAlignment: Text.AlignVCenter
                anchors.rightMargin: parent.width*0.4
                anchors.bottomMargin: 0
                anchors.topMargin: 0
                anchors.leftMargin: parent.width*0.2
                fontSizeMode: Text.Fit
            }

            Image {
                id: image1
                x: 0
                y: parent.height*0.05
                width: parent.height*0.9
                height: parent.height*0.9
                source: "../../resources/search-icon.png"
                fillMode: Image.PreserveAspectFit
                anchors.left: scannedDevicesLabel.right
            }

            Button {
                id: scanPanelBackButton
                x: 0
                y: parent.height*0.05
                width: parent.height*0.9
                height: parent.height*0.9
                visible: true
                text: qsTr("Button")
                display: AbstractButton.IconOnly
                anchors.left: parent.left

                background: Rectangle {
                    color: "transparent"
                }


                Image {
                    id: image2
                    anchors.fill: parent
                    source: "../../resources/back-icon.png"
                    fillMode: Image.PreserveAspectFit
                }

                onClicked: {
                    deviceScanPanel.visible = false
                    scannedDevicesListModel.clear()
                }
            }
        }

        ListView {
            id: scannedDevicesList
            x: 0
            width: parent.width
            height: parent.height*0.85
            visible: true
            anchors.bottom: parent.bottom
            delegate: Item {
                x: 0
                width: scannedDevicesList.width
                height: scannedDevicesList.height*0.2
                // height: currentIndex
                property int currentIndexProp: currentIndex
                Rectangle {
                    width: parent.width
                    height: parent.height*0.2
                    color: "transparent"
                }
                Rectangle {
                    width: parent.width
                    height: parent.height*0.8
                    color: "#2F4c4ceb"
                    Text {
                        text: name
                        anchors.verticalCenter: parent.verticalCenter
                        font.bold: true
                    }
                    MouseArea {
                        anchors.fill: parent
                        onClicked: {
                            console.log("Device index:" + currentIndex)
                            bleController.setDeviceAsPaired(currentIndex)
                            bleController.startInitialServiceScan(currentIndex)
                        }
                    }
                }
            }
            model: scannedDevicesListModel


        }

        ListModel {
            id: scannedDevicesListModel
            // ListElement {
            //     name:"Test"
            //     currentIndex: 6
            // }
        }


    }




    Rectangle {
        id: warningPanel
        x: parent.width/2 - width/2
        width: parent.width *0.9
        height: parent.height*0.4
        visible: false
        color: "#b33e3e3e"
        radius: 45
        anchors.top: parent.top
        anchors.topMargin: parent.height*0.3


        Text {
            id: warningText
            visible: true
            color: "#ffffff"
            text: qsTr("Warning")
            wrapMode: Text.Wrap
            anchors.fill: parent
            font.pixelSize: 48
            horizontalAlignment: Text.AlignHCenter
            verticalAlignment: Text.AlignVCenter
            anchors.rightMargin: 15
            anchors.leftMargin: 15
            anchors.bottomMargin: 15
            anchors.topMargin: parent.height*0.15
            fontSizeMode: Text.Fit
        }

        Button {
            id: warningPanelBackButton
            x: 0
            y: 0
            width: parent.height*0.15
            height: parent.height*0.15
            visible: true
            text: qsTr("Button")
            anchors.left: parent.left
            anchors.top: parent.top
            z: 3
            anchors.leftMargin: 0
            anchors.topMargin: 0
            display: AbstractButton.IconOnly
            background: Rectangle {
                color: "transparent"
            }

            onClicked:{
                this.parent.visible = false
            }

            Image {
                id: image3
                anchors.fill: parent
                source: "../../resources/back-icon.png"
                z: -1
                fillMode: Image.PreserveAspectFit
            }
        }
    }
}

/*##^##
Designer {
    D{i:0;autoSize:true;formeditorZoom:0.25;height:480;width:640}
}
##^##*/
