var pouchdb
var deviceName

export const state = {
  myNodes: [],
  activeNode: {},
}

export const mutations = {
  ADD_NODE() {
    return pouchdb
      .get(deviceName)
      .then(function () {
        var uniqueid =
          Math.random().toString(36).substring(2, 15) +
          Math.random().toString(36).substring(2, 15)
        pouchdb.get(deviceName).then(function (doc) {
          doc.nodes.push({
            node_id: uniqueid,
            node_text: '',
            node_owner: deviceName,
            node_type: 'sheet',
            node_shape: 'square',
            node_deleted: false,
            node_readmode: false,
            node_color: '#9bc2d8',
          })

          return pouchdb
            .put({
              _id: deviceName,
              _rev: doc._rev,
              nodes: doc.nodes,
            })
            .then(function () {
              return pouchdb.get(deviceName).then(function (doc) {
                state.myNodes = doc.nodes
                var end = Object.keys(state.myNodes).length - 1
                const newNode = {
                  nodeid: state.myNodes[end].node_id,
                  nodetext: state.myNodes[end].node_text,
                }
                // this was to set quick focus on new nodes
                // i think... need to check old code
                state.activeNode = newNode
              })
            })
            .catch(function (err) {
              console.log(err)
            })
        })
      })
      .catch(function (err) {
        console.log(err)
        if (err.status == 404) {
          var uniqueid =
            Math.random().toString(36).substring(2, 15) +
            Math.random().toString(36).substring(2, 15)

          pouchdb.put({
            _id: deviceName,
            nodes: [
              {
                node_id: uniqueid,
                node_text: '',
                node_owner: deviceName,
                node_type: 'sheet',
                node_shape: 'square',
                node_deleted: false,
                node_readmode: false,
                node_color: '#9bc2d8',
              },
            ],
          })
        }
      })
  },
  GET_NODES() {
    // console.log('called ' + deviceName)
    pouchdb
      .get(deviceName)
      .then(function (doc) {
        var i
        for (i = 0; i < Object.keys(doc.nodes).length; i++) {
          state.myNodes = doc.nodes
        }
      })
      .catch(function (err) {
        console.log(err)
      })
    // TODO: Get other nodes from all other devices
  },

  EDIT_NODE(state, e) {
    var i
    for (i = 0; i < Object.keys(state.myNodes).length; i++) {
      if (e.nodeid == state.myNodes[i].node_id) {
        state.myNodes[i].node_text = e.nodetext
      }
    }
    pouchdb
      .get(deviceName)
      .then(function (doc) {
        // put the store into pouchdb

        return pouchdb.bulkDocs([
          {
            _id: deviceName,
            _rev: doc._rev,
            _attachments: doc._attachments,
            nodes: state.myNodes,
          },
        ])
      })
      .then(function () {
        return pouchdb.get(deviceName).then(function (doc) {
          state.myNodes = doc.nodes
        })
      })
      .catch(function (err) {
        if (err.status == 404) {
          // pouchdb.put({  })
        }
      })
  },
}

export const actions = {
  addNode: ({ commit }, e) => {
    commit('ADD_NODE', e)
  },

  getNodes: ({ commit }, e) => {
    commit('GET_NODES', e)
  },

  editNode: ({ commit }, { nodeid, nodetext }) => {
    commit('EDIT_NODE', { nodeid, nodetext })
  },

  getMicrocosm(vuexContext) {
    // var lastmicrocosm = localStorage.getItem('nogg_microcosm')
    //  pouchdb = new PouchDB(lastmicrocosm)
    // deviceName = localStorage.getItem('nogg_name')
    //vuexContext.dispatch('startDB', null, { root: true })
    deviceName = vuexContext.rootState.setup.deviceName
    pouchdb = vuexContext.rootState.setup.pouchdb
  },
}
