import { createStore } from 'vuex'
import PouchDB from 'pouchdb'
import Router from '@/router'

// Checking for previous microcosm last entered from LocalStorage
if (localStorage.getItem('nogg_microcosm') == null) {
  var microcosm = 'first_visit'
} else {
  microcosm = localStorage.getItem('nogg_microcosm')
}

// Checking for previous name last entered from LocalStorage
if (localStorage.getItem('nogg_name') == null) {
  var name = 'no_name'
} else {
  name = localStorage.getItem('nogg_name')
}

// set up PouchDB and add a remote from env files
var pouchdb = new PouchDB(microcosm)
var remote =
  process.env.VUE_APP_COUCH_HTTP +
  '://' +
  process.env.VUE_APP_COUCH_USER +
  ':' +
  process.env.VUE_APP_COUCH_PASS +
  process.env.VUE_APP_COUCH_URL +
  microcosm +
  '/'

export const store = createStore({
  state() {
    return {
      version: process.env.VUE_APP_VERSION,
      microcosm: '',
      name: name,
      configRemote: [],
    }
  },
  mutations: {
    SET_NAME(state, doc) {
      state.name = doc
      store.commit('GET_MY_NODES')
    },

    SET_MICROCOSM(state, doc) {
      const urlmicrocosm = Router.currentRoute.params.microcosm
      pouchdb.close().then(function () {
        // if the URL Parameter has /microcosm/usethisname
        if (urlmicrocosm != undefined) {
          microcosm = urlmicrocosm
          localStorage.setItem('nogg_microcosm', microcosm)
        } else {
          microcosm = doc
        }

        if (state.configRemote && state.configRemote.length > 0) {
          remote =
            state.configRemote[0].protocol +
            state.configRemote[0].couchusername +
            ':' +
            state.configRemote[0].couchpassword +
            '@' +
            state.configRemote[0].couchurl +
            '/' +
            microcosm +
            '/'
        } else {
          remote =
            process.env.VUE_APP_COUCH_HTTP +
            '://' +
            process.env.VUE_APP_COUCH_USER +
            ':' +
            process.env.VUE_APP_COUCH_PASS +
            process.env.VUE_APP_COUCH_URL +
            microcosm +
            '/'
        }
        store.dispatch('syncDB')
      })
    },
  },
  actions: {
    syncDB: () => {
      pouchdb.replicate.from(remote).on('complete', function () {
        // turn on two-way, continuous, retriable sync
        pouchdb
          .sync(remote, {
            live: true,
            since: 'now',
            retry: true,
            attachments: true,
          })
          .on('change', function () {
            // pop info into function to find out more
          })
          .on('paused', function () {})
          .on('active', function () {})
          .on('denied', function () {})
          .on('complete', function () {})
          .on('error', function (err) {
            console.log(err)
          })
      })
    },

    setName: ({ commit }, e) => {
      commit('SET_NAME', e)
    },
    setMicrocosm: ({ commit }, e) => {
      commit('SET_MICROCOSM', e)
    },
  },
  modules: {},
})

store.dispatch('syncDB')
